rule win_ransoc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ransoc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ransoc"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7478 8bd7 8d4c2430 2bd0 3bf9 }
            // n = 6, score = 300
            //   85c0                 | test                eax, eax
            //   7478                 | je                  0x7a
            //   8bd7                 | mov                 edx, edi
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   2bd0                 | sub                 edx, eax
            //   3bf9                 | cmp                 edi, ecx

        $sequence_1 = { 85d2 7403 894238 85c0 7415 397030 7508 }
            // n = 7, score = 300
            //   85d2                 | test                edx, edx
            //   7403                 | je                  5
            //   894238               | mov                 dword ptr [edx + 0x38], eax
            //   85c0                 | test                eax, eax
            //   7415                 | je                  0x17
            //   397030               | cmp                 dword ptr [eax + 0x30], esi
            //   7508                 | jne                 0xa

        $sequence_2 = { 895038 8bd0 8bc7 8bfa 89583c }
            // n = 5, score = 300
            //   895038               | mov                 dword ptr [eax + 0x38], edx
            //   8bd0                 | mov                 edx, eax
            //   8bc7                 | mov                 eax, edi
            //   8bfa                 | mov                 edi, edx
            //   89583c               | mov                 dword ptr [eax + 0x3c], ebx

        $sequence_3 = { 5e 895004 8b542428 5d 894808 5b }
            // n = 6, score = 300
            //   5e                   | pop                 esi
            //   895004               | mov                 dword ptr [eax + 4], edx
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   5d                   | pop                 ebp
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   5b                   | pop                 ebx

        $sequence_4 = { 8b742414 8916 894234 895038 8bd0 8bc7 8bfa }
            // n = 7, score = 300
            //   8b742414             | mov                 esi, dword ptr [esp + 0x14]
            //   8916                 | mov                 dword ptr [esi], edx
            //   894234               | mov                 dword ptr [edx + 0x34], eax
            //   895038               | mov                 dword ptr [eax + 0x38], edx
            //   8bd0                 | mov                 edx, eax
            //   8bc7                 | mov                 eax, edi
            //   8bfa                 | mov                 edi, edx

        $sequence_5 = { 3b780c 7508 8b7910 3b7810 7f2c 3bd6 }
            // n = 6, score = 300
            //   3b780c               | cmp                 edi, dword ptr [eax + 0xc]
            //   7508                 | jne                 0xa
            //   8b7910               | mov                 edi, dword ptr [ecx + 0x10]
            //   3b7810               | cmp                 edi, dword ptr [eax + 0x10]
            //   7f2c                 | jg                  0x2e
            //   3bd6                 | cmp                 edx, esi

        $sequence_6 = { 8b5034 895134 8b4834 85c9 7406 8b5030 895130 }
            // n = 7, score = 300
            //   8b5034               | mov                 edx, dword ptr [eax + 0x34]
            //   895134               | mov                 dword ptr [ecx + 0x34], edx
            //   8b4834               | mov                 ecx, dword ptr [eax + 0x34]
            //   85c9                 | test                ecx, ecx
            //   7406                 | je                  8
            //   8b5030               | mov                 edx, dword ptr [eax + 0x30]
            //   895130               | mov                 dword ptr [ecx + 0x30], edx

        $sequence_7 = { 0f8434020000 8b4830 3bca 7571 }
            // n = 4, score = 300
            //   0f8434020000         | je                  0x23a
            //   8b4830               | mov                 ecx, dword ptr [eax + 0x30]
            //   3bca                 | cmp                 ecx, edx
            //   7571                 | jne                 0x73

        $sequence_8 = { 8b4e2c 751b f6c101 7516 }
            // n = 4, score = 300
            //   8b4e2c               | mov                 ecx, dword ptr [esi + 0x2c]
            //   751b                 | jne                 0x1d
            //   f6c101               | test                cl, 1
            //   7516                 | jne                 0x18

        $sequence_9 = { 895134 8b4834 85c9 7406 8b5030 895130 8b482c }
            // n = 7, score = 300
            //   895134               | mov                 dword ptr [ecx + 0x34], edx
            //   8b4834               | mov                 ecx, dword ptr [eax + 0x34]
            //   85c9                 | test                ecx, ecx
            //   7406                 | je                  8
            //   8b5030               | mov                 edx, dword ptr [eax + 0x30]
            //   895130               | mov                 dword ptr [ecx + 0x30], edx
            //   8b482c               | mov                 ecx, dword ptr [eax + 0x2c]

    condition:
        7 of them and filesize < 958464
}