rule win_ransomlock_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ransomlock."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ransomlock"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c414 8dbdb0fdffff 32c0 b908020000 f3aa 8b3d???????? }
            // n = 6, score = 100
            //   83c414               | add                 esp, 0x14
            //   8dbdb0fdffff         | lea                 edi, [ebp - 0x250]
            //   32c0                 | xor                 al, al
            //   b908020000           | mov                 ecx, 0x208
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   8b3d????????         |                     

        $sequence_1 = { ffd2 8b45e8 50 ff15???????? 5f 5e 5b }
            // n = 7, score = 100
            //   ffd2                 | call                edx
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_2 = { 85f6 0f84d1000000 6a01 53 6a03 53 53 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   0f84d1000000         | je                  0xd7
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   6a03                 | push                3
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_3 = { c20400 55 8bec 8b4508 ff4850 }
            // n = 5, score = 100
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff4850               | dec                 dword ptr [eax + 0x50]

        $sequence_4 = { 8b45fc 83c704 ff4dec 75c4 8b08 8b5108 50 }
            // n = 7, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c704               | add                 edi, 4
            //   ff4dec               | dec                 dword ptr [ebp - 0x14]
            //   75c4                 | jne                 0xffffffc6
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   50                   | push                eax

        $sequence_5 = { ffd0 85c0 7822 8b45fc 3bc6 741b 8b08 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   7822                 | js                  0x24
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   3bc6                 | cmp                 eax, esi
            //   741b                 | je                  0x1d
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_6 = { a1???????? 8945fc 85c0 7450 817d0c10020000 }
            // n = 5, score = 100
            //   a1????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax
            //   7450                 | je                  0x52
            //   817d0c10020000       | cmp                 dword ptr [ebp + 0xc], 0x210

        $sequence_7 = { 8bf0 85f6 7512 8d95d4fdffff 52 57 }
            // n = 6, score = 100
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7512                 | jne                 0x14
            //   8d95d4fdffff         | lea                 edx, [ebp - 0x22c]
            //   52                   | push                edx
            //   57                   | push                edi

        $sequence_8 = { 8b45f0 3bc6 0f8418010000 8b08 8d55fc }
            // n = 5, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   3bc6                 | cmp                 eax, esi
            //   0f8418010000         | je                  0x11e
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8d55fc               | lea                 edx, [ebp - 4]

        $sequence_9 = { 5d c22400 b801000000 5d c22400 }
            // n = 5, score = 100
            //   5d                   | pop                 ebp
            //   c22400               | ret                 0x24
            //   b801000000           | mov                 eax, 1
            //   5d                   | pop                 ebp
            //   c22400               | ret                 0x24

    condition:
        7 of them and filesize < 360448
}