rule win_rdat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rdat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rdat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8bc3 4c0f42c7 4d85c0 7504 }
            // n = 4, score = 300
            //   4c8bc3               | dec                 eax
            //   4c0f42c7             | cmp                 dword ptr [ecx + 0x18], 0x10
            //   4d85c0               | dec                 eax
            //   7504                 | mov                 edi, dword ptr [ecx + 0x10]

        $sequence_1 = { 4c8b4548 4d85c0 0f84db000000 4885c0 0f84d2000000 }
            // n = 5, score = 300
            //   4c8b4548             | jne                 0x20
            //   4d85c0               | dec                 eax
            //   0f84db000000         | cmp                 edi, ebx
            //   4885c0               | jae                 0x1a
            //   0f84d2000000         | or                  eax, 0xffffffff

        $sequence_2 = { 4898 4885c0 751e 483bfb }
            // n = 4, score = 300
            //   4898                 | dec                 eax
            //   4885c0               | cwde                
            //   751e                 | dec                 eax
            //   483bfb               | test                eax, eax

        $sequence_3 = { 498b4638 498b1c04 4885db 0f843f010000 }
            // n = 4, score = 300
            //   498b4638             | test                eax, eax
            //   498b1c04             | jne                 0x20
            //   4885db               | dec                 eax
            //   0f843f010000         | cmp                 edi, ebx

        $sequence_4 = { 4863ca 418907 33c0 448b5770 }
            // n = 4, score = 300
            //   4863ca               | cmp                 edi, ebx
            //   418907               | dec                 esp
            //   33c0                 | mov                 eax, ebx
            //   448b5770             | dec                 esp

        $sequence_5 = { 25ffffff0f 743d 83e801 7427 }
            // n = 4, score = 300
            //   25ffffff0f           | dec                 esp
            //   743d                 | mov                 eax, ebx
            //   83e801               | dec                 esp
            //   7427                 | cmovb               eax, edi

        $sequence_6 = { 4883cbff 6690 48ffc3 4038341a 75f7 4883791810 488b7910 }
            // n = 7, score = 300
            //   4883cbff             | dec                 ebp
            //   6690                 | test                eax, eax
            //   48ffc3               | jne                 0xd
            //   4038341a             | mov                 eax, esi
            //   75f7                 | dec                 eax
            //   4883791810           | cmp                 edi, ebx
            //   488b7910             | dec                 esp

        $sequence_7 = { 48895808 48896810 48897018 488bf2 4c8bf9 }
            // n = 5, score = 300
            //   48895808             | dec                 esp
            //   48896810             | cmovb               eax, edi
            //   48897018             | dec                 eax
            //   488bf2               | mov                 edi, dword ptr [ecx + 0x10]
            //   4c8bf9               | jb                  5

        $sequence_8 = { 75f7 4883791810 488b7910 7203 488b09 483bfb 4c8bc3 }
            // n = 7, score = 300
            //   75f7                 | dec                 eax
            //   4883791810           | cmp                 edi, ebx
            //   488b7910             | jae                 0x1a
            //   7203                 | or                  eax, 0xffffffff
            //   488b09               | dec                 eax
            //   483bfb               | mov                 ebx, dword ptr [esp + 0x30]
            //   4c8bc3               | jne                 0xfffffff9

        $sequence_9 = { 4e8b44c8f8 7816 8d4a01 4d8b4008 }
            // n = 4, score = 300
            //   4e8b44c8f8           | jae                 0x1a
            //   7816                 | or                  eax, 0xffffffff
            //   8d4a01               | dec                 eax
            //   4d8b4008             | mov                 ebx, dword ptr [esp + 0x30]

        $sequence_10 = { 85c0 740b b9e8030000 ff15???????? }
            // n = 4, score = 300
            //   85c0                 | dec                 eax
            //   740b                 | cmp                 dword ptr [ecx + 0x18], 0x10
            //   b9e8030000           | dec                 eax
            //   ff15????????         |                     

        $sequence_11 = { 25ffffff0f 4c8bc1 83f803 0f85b2000000 488b01 }
            // n = 5, score = 300
            //   25ffffff0f           | dec                 eax
            //   4c8bc1               | cmp                 dword ptr [ecx + 0x18], 0x10
            //   83f803               | dec                 eax
            //   0f85b2000000         | mov                 edi, dword ptr [ecx + 0x10]
            //   488b01               | jb                  5

        $sequence_12 = { 4883c504 453bc4 7358 e9???????? }
            // n = 4, score = 300
            //   4883c504             | dec                 eax
            //   453bc4               | cmp                 edi, ebx
            //   7358                 | dec                 esp
            //   e9????????           |                     

        $sequence_13 = { 746c 4883ff01 7266 498bde 48833d????????10 480f431d???????? }
            // n = 6, score = 100
            //   746c                 | test                eax, eax
            //   4883ff01             | dec                 eax
            //   7266                 | cmp                 edi, ebx
            //   498bde               | dec                 esp
            //   48833d????????10     |                     
            //   480f431d????????     |                     

        $sequence_14 = { 488d0cc0 4863c2 4803c8 420fb6940980360200 }
            // n = 4, score = 100
            //   488d0cc0             | mov                 eax, ebx
            //   4863c2               | dec                 esp
            //   4803c8               | cmovb               eax, edi
            //   420fb6940980360200     | dec    ebp

        $sequence_15 = { 488d95e8010000 488d8d68010000 e8???????? 90 488d9568010000 4883bd8001000010 }
            // n = 6, score = 100
            //   488d95e8010000       | test                eax, eax
            //   488d8d68010000       | jne                 0x10
            //   e8????????           |                     
            //   90                   | mov                 eax, esi
            //   488d9568010000       | jmp                 0x15
            //   4883bd8001000010     | dec                 eax

    condition:
        7 of them and filesize < 1573888
}