rule win_remy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.remy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.remy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 64a300000000 8b4508 8bf9 8b4d0c 89442428 33c0 }
            // n = 6, score = 200
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8bf9                 | mov                 edi, ecx
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 8b06 8995b8efffff 8b5608 898db0efffff 8d8d38dfffff 8985bcefffff 8995c0efffff }
            // n = 7, score = 200
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8995b8efffff         | mov                 dword ptr [ebp - 0x1048], edx
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   898db0efffff         | mov                 dword ptr [ebp - 0x1050], ecx
            //   8d8d38dfffff         | lea                 ecx, [ebp - 0x20c8]
            //   8985bcefffff         | mov                 dword ptr [ebp - 0x1044], eax
            //   8995c0efffff         | mov                 dword ptr [ebp - 0x1040], edx

        $sequence_2 = { 83791810 8d4104 7202 8b00 8b5120 52 50 }
            // n = 7, score = 200
            //   83791810             | cmp                 dword ptr [ecx + 0x18], 0x10
            //   8d4104               | lea                 eax, [ecx + 4]
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b5120               | mov                 edx, dword ptr [ecx + 0x20]
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_3 = { e8???????? c645fc01 8b08 8bb564ffffff 8d41f0 83c6f0 3bc6 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8bb564ffffff         | mov                 esi, dword ptr [ebp - 0x9c]
            //   8d41f0               | lea                 eax, [ecx - 0x10]
            //   83c6f0               | add                 esi, -0x10
            //   3bc6                 | cmp                 eax, esi

        $sequence_4 = { 2bc6 83e808 50 8d8d54ffffff 8d5e08 51 }
            // n = 6, score = 200
            //   2bc6                 | sub                 eax, esi
            //   83e808               | sub                 eax, 8
            //   50                   | push                eax
            //   8d8d54ffffff         | lea                 ecx, [ebp - 0xac]
            //   8d5e08               | lea                 ebx, [esi + 8]
            //   51                   | push                ecx

        $sequence_5 = { 8b4b04 4e 833cb100 7517 6a10 e8???????? 83c404 }
            // n = 7, score = 200
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]
            //   4e                   | dec                 esi
            //   833cb100             | cmp                 dword ptr [ecx + esi*4], 0
            //   7517                 | jne                 0x19
            //   6a10                 | push                0x10
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_6 = { 8b06 50 83c604 56 8b74244c 56 e8???????? }
            // n = 7, score = 200
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   50                   | push                eax
            //   83c604               | add                 esi, 4
            //   56                   | push                esi
            //   8b74244c             | mov                 esi, dword ptr [esp + 0x4c]
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_7 = { 8d8d00ffffff 8bd6 e8???????? 83c408 3bc3 8b8500ffffff 0f85ce070000 }
            // n = 7, score = 200
            //   8d8d00ffffff         | lea                 ecx, [ebp - 0x100]
            //   8bd6                 | mov                 edx, esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   3bc3                 | cmp                 eax, ebx
            //   8b8500ffffff         | mov                 eax, dword ptr [ebp - 0x100]
            //   0f85ce070000         | jne                 0x7d4

        $sequence_8 = { 8d4dc8 51 6a08 68ffff0000 56 897dc8 ff15???????? }
            // n = 7, score = 200
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   51                   | push                ecx
            //   6a08                 | push                8
            //   68ffff0000           | push                0xffff
            //   56                   | push                esi
            //   897dc8               | mov                 dword ptr [ebp - 0x38], edi
            //   ff15????????         |                     

        $sequence_9 = { 8b4210 83c7f0 89642448 89642448 ffd0 395f0c 8d4f0c }
            // n = 7, score = 200
            //   8b4210               | mov                 eax, dword ptr [edx + 0x10]
            //   83c7f0               | add                 edi, -0x10
            //   89642448             | mov                 dword ptr [esp + 0x48], esp
            //   89642448             | mov                 dword ptr [esp + 0x48], esp
            //   ffd0                 | call                eax
            //   395f0c               | cmp                 dword ptr [edi + 0xc], ebx
            //   8d4f0c               | lea                 ecx, [edi + 0xc]

    condition:
        7 of them and filesize < 507904
}