rule win_revenant_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.revenant."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.revenant"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4889442458 4c8b4c2458 488d442470 41b800040000 4889d9 }
            // n = 5, score = 100
            //   4889442458           | mov                 ecx, ebx
            //   4c8b4c2458           | test                eax, eax
            //   488d442470           | je                  0x293
            //   41b800040000         | xor                 edx, edx
            //   4889d9               | dec                 eax

        $sequence_1 = { 48ffc7 e8???????? ebe4 488d0d26370000 e8???????? 448b442428 4889f1 }
            // n = 7, score = 100
            //   48ffc7               | dec                 edi
            //   e8????????           |                     
            //   ebe4                 | rep stosd           dword ptr es:[edi], eax
            //   488d0d26370000       | jne                 0x484
            //   e8????????           |                     
            //   448b442428           | dec                 eax
            //   4889f1               | mov                 edi, edx

        $sequence_2 = { 488d0d12260000 4989c1 e8???????? 488b742428 b902000000 e8???????? }
            // n = 6, score = 100
            //   488d0d12260000       | call                esi
            //   4989c1               | xor                 edx, edx
            //   e8????????           |                     
            //   488b742428           | mov                 ecx, 0x40
            //   b902000000           | dec                 eax
            //   e8????????           |                     

        $sequence_3 = { 4889ef 4989c0 e8???????? 488b4c2428 31c0 f3aa 4889e9 }
            // n = 7, score = 100
            //   4889ef               | inc                 ecx
            //   4989c0               | movzx               edx, word ptr [eax + 0x14]
            //   e8????????           |                     
            //   488b4c2428           | inc                 bp
            //   31c0                 | test                ecx, ecx
            //   f3aa                 | inc                 cx
            //   4889e9               | mov                 dword ptr [esi], esi

        $sequence_4 = { 7408 4889c7 4889d9 f3a4 }
            // n = 4, score = 100
            //   7408                 | dec                 eax
            //   4889c7               | mov                 ecx, dword ptr [eax]
            //   4889d9               | xor                 edx, edx
            //   f3a4                 | dec                 eax

        $sequence_5 = { 488d0d28380000 89c2 e8???????? 4885f6 0f84b4000000 }
            // n = 5, score = 100
            //   488d0d28380000       | je                  0x6fa
            //   89c2                 | dec                 eax
            //   e8????????           |                     
            //   4885f6               | cmp                 edi, ebx
            //   0f84b4000000         | jne                 0x6c7

        $sequence_6 = { e8???????? 418b542420 4889d9 e8???????? 488d542420 4989f0 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   418b542420           | je                  0x2f0
            //   4889d9               | dec                 eax
            //   e8????????           |                     
            //   488d542420           | mov                 edx, ecx
            //   4989f0               | je                  0x2ed

        $sequence_7 = { 4889c2 4889442420 7424 448b442428 31c9 }
            // n = 5, score = 100
            //   4889c2               | je                  0x370
            //   4889442420           | xor                 esi, esi
            //   7424                 | xor                 ebx, ebx
            //   448b442428           | xor                 ebp, ebp
            //   31c9                 | cmp                 dword ptr [edi + 0x3c], 0

        $sequence_8 = { 4c89c2 7208 035008 4839d1 72ac 4883c028 4c39c8 }
            // n = 7, score = 100
            //   4c89c2               | xor                 eax, edx
            //   7208                 | mov                 byte ptr [edx], 0x5c
            //   035008               | dec                 eax
            //   4839d1               | inc                 edx
            //   72ac                 | jmp                 0x9e6
            //   4883c028             | dec                 eax
            //   4c39c8               | mov                 ecx, ebx

        $sequence_9 = { 448b442428 4889f1 488b542420 488d3d40370000 488d2d08370000 4c8d2520370000 }
            // n = 6, score = 100
            //   448b442428           | push                edi
            //   4889f1               | push                esi
            //   488b542420           | push                ebx
            //   488d3d40370000       | dec                 eax
            //   488d2d08370000       | sub                 esp, 0x458
            //   4c8d2520370000       | xor                 eax, eax

    condition:
        7 of them and filesize < 99328
}