rule win_rhadamanthys_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rhadamanthys."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rhadamanthys"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33f0 33fa 891ccd28100803 8bde 892ccd2c100803 8bef }
            // n = 6, score = 100
            //   33f0                 | xor                 esi, eax
            //   33fa                 | xor                 edi, edx
            //   891ccd28100803       | mov                 dword ptr [ecx*8 + 0x3081028], ebx
            //   8bde                 | mov                 ebx, esi
            //   892ccd2c100803       | mov                 dword ptr [ecx*8 + 0x308102c], ebp
            //   8bef                 | mov                 ebp, edi

        $sequence_1 = { 33f0 891ccd30280803 892ccd34280803 33fa 8bde 8bef 0fa4f708 }
            // n = 7, score = 100
            //   33f0                 | xor                 esi, eax
            //   891ccd30280803       | mov                 dword ptr [ecx*8 + 0x3082830], ebx
            //   892ccd34280803       | mov                 dword ptr [ecx*8 + 0x3082834], ebp
            //   33fa                 | xor                 edi, edx
            //   8bde                 | mov                 ebx, esi
            //   8bef                 | mov                 ebp, edi
            //   0fa4f708             | shld                edi, esi, 8

        $sequence_2 = { 0facdf08 81e7ff000000 3304fd28400803 3314fd2c400803 c1e918 }
            // n = 5, score = 100
            //   0facdf08             | shrd                edi, ebx, 8
            //   81e7ff000000         | and                 edi, 0xff
            //   3304fd28400803       | xor                 eax, dword ptr [edi*8 + 0x3084028]
            //   3314fd2c400803       | xor                 edx, dword ptr [edi*8 + 0x308402c]
            //   c1e918               | shr                 ecx, 0x18

        $sequence_3 = { c1e608 33f0 891ccd28280803 892ccd2c280803 33fa }
            // n = 5, score = 100
            //   c1e608               | shl                 esi, 8
            //   33f0                 | xor                 esi, eax
            //   891ccd28280803       | mov                 dword ptr [ecx*8 + 0x3082828], ebx
            //   892ccd2c280803       | mov                 dword ptr [ecx*8 + 0x308282c], ebp
            //   33fa                 | xor                 edi, edx

        $sequence_4 = { 66837e082c 0f8692000000 6a04 6800100000 6800004000 }
            // n = 5, score = 100
            //   66837e082c           | cmp                 word ptr [esi + 8], 0x2c
            //   0f8692000000         | jbe                 0x98
            //   6a04                 | push                4
            //   6800100000           | push                0x1000
            //   6800004000           | push                0x400000

        $sequence_5 = { 03c6 50 8b03 034508 50 e8???????? }
            // n = 6, score = 100
            //   03c6                 | add                 eax, esi
            //   50                   | push                eax
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   034508               | add                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { c784248c01000068ea0303 c7842490010000b4190403 c784249401000070490403 c784249801000018770403 c784249c01000058a20403 c78424a001000010d30403 c78424a401000034010503 }
            // n = 7, score = 100
            //   c784248c01000068ea0303     | mov    dword ptr [esp + 0x18c], 0x303ea68
            //   c7842490010000b4190403     | mov    dword ptr [esp + 0x190], 0x30419b4
            //   c784249401000070490403     | mov    dword ptr [esp + 0x194], 0x3044970
            //   c784249801000018770403     | mov    dword ptr [esp + 0x198], 0x3047718
            //   c784249c01000058a20403     | mov    dword ptr [esp + 0x19c], 0x304a258
            //   c78424a001000010d30403     | mov    dword ptr [esp + 0x1a0], 0x304d310
            //   c78424a401000034010503     | mov    dword ptr [esp + 0x1a4], 0x3050134

        $sequence_7 = { 837df400 0f84a0010000 8365e400 eb07 8b45e4 }
            // n = 5, score = 100
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   0f84a0010000         | je                  0x1a6
            //   8365e400             | and                 dword ptr [ebp - 0x1c], 0
            //   eb07                 | jmp                 9
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_8 = { 5e 5b c9 c20c00 8b4c2404 8a01 }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]
            //   8a01                 | mov                 al, byte ptr [ecx]

        $sequence_9 = { c7842418020000383f0403 c784241c020000c46c0403 c7842420020000449a0403 c784242402000034ca0403 c7842428020000fcf90403 c784242c020000182b0503 }
            // n = 6, score = 100
            //   c7842418020000383f0403     | mov    dword ptr [esp + 0x218], 0x3043f38
            //   c784241c020000c46c0403     | mov    dword ptr [esp + 0x21c], 0x3046cc4
            //   c7842420020000449a0403     | mov    dword ptr [esp + 0x220], 0x3049a44
            //   c784242402000034ca0403     | mov    dword ptr [esp + 0x224], 0x304ca34
            //   c7842428020000fcf90403     | mov    dword ptr [esp + 0x228], 0x304f9fc
            //   c784242c020000182b0503     | mov    dword ptr [esp + 0x22c], 0x3052b18

    condition:
        7 of them and filesize < 1111040
}