rule win_rombertik_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rombertik."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rombertik"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7549 68???????? 8d95e0feffff 52 ffd7 }
            // n = 5, score = 200
            //   7549                 | jne                 0x4b
            //   68????????           |                     
            //   8d95e0feffff         | lea                 edx, [ebp - 0x120]
            //   52                   | push                edx
            //   ffd7                 | call                edi

        $sequence_1 = { 0fb69c3500ffffff 03d9 81e3ff000080 7908 4b }
            // n = 5, score = 200
            //   0fb69c3500ffffff     | movzx               ebx, byte ptr [ebp + esi - 0x100]
            //   03d9                 | add                 ebx, ecx
            //   81e3ff000080         | and                 ebx, 0x800000ff
            //   7908                 | jns                 0xa
            //   4b                   | dec                 ebx

        $sequence_2 = { 8b5508 8b45fc 52 6800010000 50 }
            // n = 5, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   52                   | push                edx
            //   6800010000           | push                0x100
            //   50                   | push                eax

        $sequence_3 = { 56 885dfd ff15???????? 85c0 0f846c010000 807dfde9 0f8462010000 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   885dfd               | mov                 byte ptr [ebp - 3], bl
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f846c010000         | je                  0x172
            //   807dfde9             | cmp                 byte ptr [ebp - 3], 0xe9
            //   0f8462010000         | je                  0x168

        $sequence_4 = { 8d85fcfeffff e8???????? 8b4508 57 }
            // n = 4, score = 200
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   57                   | push                edi

        $sequence_5 = { 68ffff1f00 ff15???????? 8bf0 3bf3 7473 }
            // n = 5, score = 200
            //   68ffff1f00           | push                0x1fffff
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   3bf3                 | cmp                 esi, ebx
            //   7473                 | je                  0x75

        $sequence_6 = { 8d95e0feffff 52 ffd7 85c0 }
            // n = 4, score = 200
            //   8d95e0feffff         | lea                 edx, [ebp - 0x120]
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax

        $sequence_7 = { 83c410 85c0 7409 6a00 ffd0 83c404 5e }
            // n = 7, score = 200
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   6a00                 | push                0
            //   ffd0                 | call                eax
            //   83c404               | add                 esp, 4
            //   5e                   | pop                 esi

        $sequence_8 = { 8d95e0feffff 52 ffd6 85c0 }
            // n = 4, score = 200
            //   8d95e0feffff         | lea                 edx, [ebp - 0x120]
            //   52                   | push                edx
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax

        $sequence_9 = { 3bc3 0f8486010000 53 6a01 8d4dfd }
            // n = 5, score = 200
            //   3bc3                 | cmp                 eax, ebx
            //   0f8486010000         | je                  0x18c
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   8d4dfd               | lea                 ecx, [ebp - 3]

    condition:
        7 of them and filesize < 73728
}