rule win_royal_dns_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.royal_dns."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.royal_dns"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 83bd80f1ffff05 7c12 8b8d7cf1ffff 51 ff15???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   83bd80f1ffff05       | cmp                 dword ptr [ebp - 0xe80], 5
            //   7c12                 | jl                  0x14
            //   8b8d7cf1ffff         | mov                 ecx, dword ptr [ebp - 0xe84]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_1 = { 83c004 8985e8faffff 3bc1 0f8725010000 }
            // n = 4, score = 100
            //   83c004               | add                 eax, 4
            //   8985e8faffff         | mov                 dword ptr [ebp - 0x518], eax
            //   3bc1                 | cmp                 eax, ecx
            //   0f8725010000         | ja                  0x12b

        $sequence_2 = { ffd6 68???????? 8d95f0fdffff 52 ffd6 57 8d85f0fdffff }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   8d95f0fdffff         | lea                 edx, [ebp - 0x210]
            //   52                   | push                edx
            //   ffd6                 | call                esi
            //   57                   | push                edi
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]

        $sequence_3 = { 75f9 8b4dfc 2bc2 8d540801 8b45f8 8910 }
            // n = 6, score = 100
            //   75f9                 | jne                 0xfffffffb
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   2bc2                 | sub                 eax, edx
            //   8d540801             | lea                 edx, [eax + ecx + 1]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8910                 | mov                 dword ptr [eax], edx

        $sequence_4 = { 0f84ad010000 83f8ff 0f84a4010000 85c0 0f849c010000 }
            // n = 5, score = 100
            //   0f84ad010000         | je                  0x1b3
            //   83f8ff               | cmp                 eax, -1
            //   0f84a4010000         | je                  0x1aa
            //   85c0                 | test                eax, eax
            //   0f849c010000         | je                  0x1a2

        $sequence_5 = { 56 8d85e8fdffff 68???????? 50 e8???????? 83c40c 8d8df0feffff }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8d85e8fdffff         | lea                 eax, [ebp - 0x218]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d8df0feffff         | lea                 ecx, [ebp - 0x110]

        $sequence_6 = { 8d95d8fcffff 6a00 52 e8???????? 0fb6730c }
            // n = 5, score = 100
            //   8d95d8fcffff         | lea                 edx, [ebp - 0x328]
            //   6a00                 | push                0
            //   52                   | push                edx
            //   e8????????           |                     
            //   0fb6730c             | movzx               esi, byte ptr [ebx + 0xc]

        $sequence_7 = { 53 6a00 6800040000 8d85f4fbffff c785dcfaffff10000000 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   6800040000           | push                0x400
            //   8d85f4fbffff         | lea                 eax, [ebp - 0x40c]
            //   c785dcfaffff10000000     | mov    dword ptr [ebp - 0x524], 0x10

        $sequence_8 = { 8b4608 52 83c00c 50 83c711 57 e8???????? }
            // n = 7, score = 100
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   52                   | push                edx
            //   83c00c               | add                 eax, 0xc
            //   50                   | push                eax
            //   83c711               | add                 edi, 0x11
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_9 = { be50000000 56 51 8d95d9feffff 52 }
            // n = 5, score = 100
            //   be50000000           | mov                 esi, 0x50
            //   56                   | push                esi
            //   51                   | push                ecx
            //   8d95d9feffff         | lea                 edx, [ebp - 0x127]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 204800
}