rule win_rustock_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rustock."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rustock"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 8d85f8fdffff 50 ff15???????? 6a01 8d85fcfeffff 50 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax

        $sequence_1 = { 8901 eb03 8b5dbc 837de000 }
            // n = 4, score = 100
            //   8901                 | mov                 dword ptr [ecx], eax
            //   eb03                 | jmp                 5
            //   8b5dbc               | mov                 ebx, dword ptr [ebp - 0x44]
            //   837de000             | cmp                 dword ptr [ebp - 0x20], 0

        $sequence_2 = { 897de4 eb10 837ddcff 740a }
            // n = 4, score = 100
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi
            //   eb10                 | jmp                 0x12
            //   837ddcff             | cmp                 dword ptr [ebp - 0x24], -1
            //   740a                 | je                  0xc

        $sequence_3 = { 29f8 83cbff f7d3 b8670e0100 8d0dc8680100 01d0 }
            // n = 6, score = 100
            //   29f8                 | sub                 eax, edi
            //   83cbff               | or                  ebx, 0xffffffff
            //   f7d3                 | not                 ebx
            //   b8670e0100           | mov                 eax, 0x10e67
            //   8d0dc8680100         | lea                 ecx, [0x168c8]
            //   01d0                 | add                 eax, edx

        $sequence_4 = { 83c404 8b1c24 83c404 5e }
            // n = 4, score = 100
            //   83c404               | add                 esp, 4
            //   8b1c24               | mov                 ebx, dword ptr [esp]
            //   83c404               | add                 esp, 4
            //   5e                   | pop                 esi

        $sequence_5 = { 7404 33c0 40 c3 33c0 c3 6a34 }
            // n = 7, score = 100
            //   7404                 | je                  6
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   6a34                 | push                0x34

        $sequence_6 = { 85c9 7506 68db030100 c3 ff15???????? }
            // n = 5, score = 100
            //   85c9                 | test                ecx, ecx
            //   7506                 | jne                 8
            //   68db030100           | push                0x103db
            //   c3                   | ret                 
            //   ff15????????         |                     

        $sequence_7 = { 770d 57 e8???????? 8bd0 85d2 59 }
            // n = 6, score = 100
            //   770d                 | ja                  0xf
            //   57                   | push                edi
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   85d2                 | test                edx, edx
            //   59                   | pop                 ecx

        $sequence_8 = { 80a04031040100 40 3bc6 72be 5e }
            // n = 5, score = 100
            //   80a04031040100       | and                 byte ptr [eax + 0x1043140], 0
            //   40                   | inc                 eax
            //   3bc6                 | cmp                 eax, esi
            //   72be                 | jb                  0xffffffc0
            //   5e                   | pop                 esi

        $sequence_9 = { 8975c0 85f6 0f848b000000 8365fc00 83c003 83e0fc e8???????? }
            // n = 7, score = 100
            //   8975c0               | mov                 dword ptr [ebp - 0x40], esi
            //   85f6                 | test                esi, esi
            //   0f848b000000         | je                  0x91
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   83c003               | add                 eax, 3
            //   83e0fc               | and                 eax, 0xfffffffc
            //   e8????????           |                     

    condition:
        7 of them and filesize < 565248
}