rule win_saint_bot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.saint_bot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.saint_bot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 668910 8bc1 5d c20c00 55 }
            // n = 5, score = 100
            //   668910               | mov                 word ptr [eax], dx
            //   8bc1                 | mov                 eax, ecx
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp

        $sequence_1 = { 668975d4 8d4508 33f6 c745b418000000 683f000f00 50 }
            // n = 6, score = 100
            //   668975d4             | mov                 word ptr [ebp - 0x2c], si
            //   8d4508               | lea                 eax, [ebp + 8]
            //   33f6                 | xor                 esi, esi
            //   c745b418000000       | mov                 dword ptr [ebp - 0x4c], 0x18
            //   683f000f00           | push                0xf003f
            //   50                   | push                eax

        $sequence_2 = { 8d45f4 50 8d85ecefffff 50 }
            // n = 4, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   8d85ecefffff         | lea                 eax, [ebp - 0x1014]
            //   50                   | push                eax

        $sequence_3 = { 83650800 8bf8 56 c745ec64000000 }
            // n = 4, score = 100
            //   83650800             | and                 dword ptr [ebp + 8], 0
            //   8bf8                 | mov                 edi, eax
            //   56                   | push                esi
            //   c745ec64000000       | mov                 dword ptr [ebp - 0x14], 0x64

        $sequence_4 = { c1f808 8847ff 807a013d 7402 880f 83c204 83c703 }
            // n = 7, score = 100
            //   c1f808               | sar                 eax, 8
            //   8847ff               | mov                 byte ptr [edi - 1], al
            //   807a013d             | cmp                 byte ptr [edx + 1], 0x3d
            //   7402                 | je                  4
            //   880f                 | mov                 byte ptr [edi], cl
            //   83c204               | add                 edx, 4
            //   83c703               | add                 edi, 3

        $sequence_5 = { 894dd8 894ddc ff15???????? ff75f8 e8???????? 59 03c0 }
            // n = 7, score = 100
            //   894dd8               | mov                 dword ptr [ebp - 0x28], ecx
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   ff15????????         |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   03c0                 | add                 eax, eax

        $sequence_6 = { e8???????? 59 59 85c0 741f 6a00 53 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   741f                 | je                  0x21
            //   6a00                 | push                0
            //   53                   | push                ebx

        $sequence_7 = { 53 8945dc e8???????? 8bd8 83c434 8b45fc 85db }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   83c434               | add                 esp, 0x34
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   85db                 | test                ebx, ebx

        $sequence_8 = { 58 6a72 668945ba 58 6a49 668945bc }
            // n = 6, score = 100
            //   58                   | pop                 eax
            //   6a72                 | push                0x72
            //   668945ba             | mov                 word ptr [ebp - 0x46], ax
            //   58                   | pop                 eax
            //   6a49                 | push                0x49
            //   668945bc             | mov                 word ptr [ebp - 0x44], ax

        $sequence_9 = { 59 59 85c0 7515 ff75f0 8d8544f0ffff }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7515                 | jne                 0x17
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   8d8544f0ffff         | lea                 eax, [ebp - 0xfbc]

    condition:
        7 of them and filesize < 93184
}