rule win_sakula_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sakula_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sakula_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6800010000 6a00 6a00 68???????? }
            // n = 5, score = 300
            //   6a00                 | and                 dword ptr [esp + 0x20], 0
            //   6800010000           | dec                 eax
            //   6a00                 | mov                 dword ptr [esp + 8], ebx
            //   6a00                 | dec                 eax
            //   68????????           |                     

        $sequence_1 = { 33c9 85f6 7e15 8a0411 84c0 7409 }
            // n = 6, score = 200
            //   33c9                 | mov                 dword ptr [ebp - 0xc], 0x2d61e5
            //   85f6                 | push                eax
            //   7e15                 | push                0
            //   8a0411               | push                0x100
            //   84c0                 | push                0
            //   7409                 | push                0

        $sequence_2 = { 742d 46 83fe03 7cd6 a1???????? 40 }
            // n = 6, score = 200
            //   742d                 | mov                 eax, dword ptr [ecx + 0x10]
            //   46                   | inc                 eax
            //   83fe03               | mov                 dword ptr [ebx + 4], eax
            //   7cd6                 | mov                 eax, dword ptr [ecx + 0xc]
            //   a1????????           |                     
            //   40                   | je                  0x17

        $sequence_3 = { b803000000 eb1b e8???????? 83f801 }
            // n = 4, score = 200
            //   b803000000           | add                 esp, 8
            //   eb1b                 | xor                 eax, eax
            //   e8????????           |                     
            //   83f801               | inc                 eax

        $sequence_4 = { e8???????? 83c404 5b 85c0 5f a3???????? 0f95c0 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | push                eax
            //   5b                   | push                dword ptr [ebp - 0x18]
            //   85c0                 | push                dword ptr [ebp - 0x1c]
            //   5f                   | lea                 eax, [ebp - 0x24]
            //   a3????????           |                     
            //   0f95c0               | cmp                 edx, 0

        $sequence_5 = { 7e0b 803c385c 7405 48 85c0 7ff5 3bc1 }
            // n = 7, score = 200
            //   7e0b                 | je                  6
            //   803c385c             | dec                 ecx
            //   7405                 | dec                 edx
            //   48                   | jmp                 0xfffffff1
            //   85c0                 | movsx               eax, byte ptr [edx]
            //   7ff5                 | cmp                 eax, 0x5a
            //   3bc1                 | jg                  0x29

        $sequence_6 = { c3 53 e8???????? 69f6a4010000 0335???????? 8bde }
            // n = 6, score = 200
            //   c3                   | pop                 ebx
            //   53                   | test                eax, eax
            //   e8????????           |                     
            //   69f6a4010000         | pop                 edi
            //   0335????????         |                     
            //   8bde                 | setne               al

        $sequence_7 = { 6800100000 6800940100 6a00 ff15???????? 8bf0 85f6 }
            // n = 6, score = 200
            //   6800100000           | mov                 ecx, dword ptr [ebp + 8]
            //   6800940100           | add                 ecx, dword ptr [ebp - 8]
            //   6a00                 | mov                 eax, dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   8bf0                 | add                 eax, 0x114
            //   85f6                 | push                eax

        $sequence_8 = { ff75f4 ff75fc e8???????? 83c408 68???????? ff75fc }
            // n = 6, score = 100
            //   ff75f4               | mov                 dword ptr [esp + 0x18], esi
            //   ff75fc               | push                edi
            //   e8????????           |                     
            //   83c408               | dec                 eax
            //   68????????           |                     
            //   ff75fc               | sub                 esp, 0x40

        $sequence_9 = { 48895c2408 4889742418 57 4883ec40 ffca }
            // n = 5, score = 100
            //   48895c2408           | mov                 eax, dword ptr [ecx]
            //   4889742418           | call                dword ptr [eax + 0xa8]
            //   57                   | cmp                 eax, esi
            //   4883ec40             | and                 dword ptr [esp + 0x58], 0
            //   ffca                 | dec                 eax

        $sequence_10 = { ff75e8 ff75e4 e8???????? 8d45dc }
            // n = 4, score = 100
            //   ff75e8               | mov                 ecx, dword ptr [esp + 0x58]
            //   ff75e4               | lea                 edx, [ebx - 0xf]
            //   e8????????           |                     
            //   8d45dc               | inc                 esp

        $sequence_11 = { ff15???????? 488364243800 488364243000 4c8bc6 33d2 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   488364243800         | dec                 eax
            //   488364243000         | lea                 ebx, [0x2308]
            //   4c8bc6               | dec                 eax
            //   33d2                 | and                 dword ptr [esp + 0x38], 0

        $sequence_12 = { ff7508 e8???????? 83c408 31c0 40 50 }
            // n = 6, score = 100
            //   ff7508               | dec                 edx
            //   e8????????           |                     
            //   83c408               | dec                 eax
            //   31c0                 | mov                 ecx, dword ptr [esp + 0x50]
            //   40                   | lea                 edx, [ebx + 0x40]
            //   50                   | dec                 eax

        $sequence_13 = { 488b4c2450 8d5340 ff15???????? 488b4c2458 8d53f1 }
            // n = 5, score = 100
            //   488b4c2450           | lea                 edx, [esp + 0x58]
            //   8d5340               | dec                 eax
            //   ff15????????         |                     
            //   488b4c2458           | mov                 ecx, eax
            //   8d53f1               | dec                 eax

        $sequence_14 = { 448d4260 e8???????? 33db 33c0 488d4de2 33d2 41b8ce070000 }
            // n = 7, score = 100
            //   448d4260             | mov                 esi, dword ptr [eax + 8]
            //   e8????????           |                     
            //   33db                 | dec                 eax
            //   33c0                 | mov                 ecx, esi
            //   488d4de2             | dec                 eax
            //   33d2                 | mov                 ecx, esi
            //   41b8ce070000         | dec                 eax

        $sequence_15 = { 0fbe02 83f85a 7f24 8b4d08 034df8 }
            // n = 5, score = 100
            //   0fbe02               | xor                 edx, edx
            //   83f85a               | inc                 ecx
            //   7f24                 | mov                 eax, 0x7ce
            //   8b4d08               | dec                 esp
            //   034df8               | mov                 eax, esi

        $sequence_16 = { ff15???????? 488d15a4100000 488d0d05210000 ff15???????? 488d1d08230000 }
            // n = 5, score = 100
            //   ff15????????         |                     
            // 
            //   488d0d05210000       | dec                 eax
            //   ff15????????         |                     
            //   488d1d08230000       | lea                 ecx, [0x2105]

        $sequence_17 = { 3bc6 741b 488b4dc7 488b01 ff90a8000000 3bc6 }
            // n = 6, score = 100
            //   3bc6                 | lea                 ebp, [eax - 0x5f]
            //   741b                 | dec                 eax
            //   488b4dc7             | sub                 esp, 0xc0
            //   488b01               | dec                 eax
            //   ff90a8000000         | and                 dword ptr [ebp - 0x39], 0
            //   3bc6                 | dec                 eax

        $sequence_18 = { 8b4508 0514010000 50 ff35???????? }
            // n = 4, score = 100
            //   8b4508               | xor                 edx, edx
            //   0514010000           | inc                 esp
            //   50                   | mov                 ecx, eax
            //   ff35????????         |                     

        $sequence_19 = { 488d68a1 4881ecc0000000 488365c700 488d15e90f0000 488d0d021f0000 498bf0 }
            // n = 6, score = 100
            //   488d68a1             | dec                 eax
            //   4881ecc0000000       | and                 dword ptr [esp + 0x30], 0
            //   488365c700           | dec                 esp
            //   488d15e90f0000       | mov                 eax, esi
            //   488d0d021f0000       | xor                 edx, edx
            //   498bf0               | dec                 eax

        $sequence_20 = { 8b4110 40 894304 8b410c }
            // n = 4, score = 100
            //   8b4110               | xor                 ecx, ecx
            //   40                   | mov                 dword ptr [esp + 0x28], edi
            //   894304               | push                0
            //   8b410c               | push                0x100

        $sequence_21 = { 8364245800 ff15???????? 488d542458 488bc8 ff15???????? 488b7008 488bce }
            // n = 7, score = 100
            //   8364245800           | lea                 edx, [0xfe9]
            //   ff15????????         |                     
            //   488d542458           | dec                 eax
            //   488bc8               | lea                 ecx, [0x1f02]
            //   ff15????????         |                     
            //   488b7008             | dec                 ecx
            //   488bce               | mov                 esi, eax

        $sequence_22 = { 83fa00 7404 49 4a ebeb }
            // n = 5, score = 100
            //   83fa00               | lea                 eax, [edx + 0x60]
            //   7404                 | xor                 ebx, ebx
            //   49                   | xor                 eax, eax
            //   4a                   | dec                 eax
            //   ebeb                 | lea                 ecx, [ebp - 0x1e]

    condition:
        7 of them and filesize < 229376
}