rule win_sanny_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sanny."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sanny"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 85c0 7514 50 50 6a7f }
            // n = 6, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7514                 | jne                 0x16
            //   50                   | push                eax
            //   50                   | push                eax
            //   6a7f                 | push                0x7f

        $sequence_1 = { a1???????? dd45f4 5b dd5810 a1???????? }
            // n = 5, score = 100
            //   a1????????           |                     
            //   dd45f4               | fld                 qword ptr [ebp - 0xc]
            //   5b                   | pop                 ebx
            //   dd5810               | fstp                qword ptr [eax + 0x10]
            //   a1????????           |                     

        $sequence_2 = { 33f5 33fd 8bce 8bc6 c1e904 c1e01c 03c8 }
            // n = 7, score = 100
            //   33f5                 | xor                 esi, ebp
            //   33fd                 | xor                 edi, ebp
            //   8bce                 | mov                 ecx, esi
            //   8bc6                 | mov                 eax, esi
            //   c1e904               | shr                 ecx, 4
            //   c1e01c               | shl                 eax, 0x1c
            //   03c8                 | add                 ecx, eax

        $sequence_3 = { 68???????? 52 e8???????? 83c408 c60000 8d84244c010000 8d8c2414020000 }
            // n = 7, score = 100
            //   68????????           |                     
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c60000               | mov                 byte ptr [eax], 0
            //   8d84244c010000       | lea                 eax, [esp + 0x14c]
            //   8d8c2414020000       | lea                 ecx, [esp + 0x214]

        $sequence_4 = { 8bc8 c1e91d 8d0cc1 8b4204 8bd0 c1ea1d 8d2cc2 }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   c1e91d               | shr                 ecx, 0x1d
            //   8d0cc1               | lea                 ecx, [ecx + eax*8]
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   8bd0                 | mov                 edx, eax
            //   c1ea1d               | shr                 edx, 0x1d
            //   8d2cc2               | lea                 ebp, [edx + eax*8]

        $sequence_5 = { 83c002 50 8d842488000000 50 ffd3 8d8c2484000000 68???????? }
            // n = 7, score = 100
            //   83c002               | add                 eax, 2
            //   50                   | push                eax
            //   8d842488000000       | lea                 eax, [esp + 0x88]
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8d8c2484000000       | lea                 ecx, [esp + 0x84]
            //   68????????           |                     

        $sequence_6 = { 8b4c2410 50 51 52 8bce c644241000 e8???????? }
            // n = 7, score = 100
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8bce                 | mov                 ecx, esi
            //   c644241000           | mov                 byte ptr [esp + 0x10], 0
            //   e8????????           |                     

        $sequence_7 = { 81c72c010000 3bf5 7cde 8d942414020000 8d842414040000 52 68???????? }
            // n = 7, score = 100
            //   81c72c010000         | add                 edi, 0x12c
            //   3bf5                 | cmp                 esi, ebp
            //   7cde                 | jl                  0xffffffe0
            //   8d942414020000       | lea                 edx, [esp + 0x214]
            //   8d842414040000       | lea                 eax, [esp + 0x414]
            //   52                   | push                edx
            //   68????????           |                     

        $sequence_8 = { 83e01f 8b0c8dc0864100 8d04c1 eb05 b8???????? f6400480 }
            // n = 6, score = 100
            //   83e01f               | and                 eax, 0x1f
            //   8b0c8dc0864100       | mov                 ecx, dword ptr [ecx*4 + 0x4186c0]
            //   8d04c1               | lea                 eax, [ecx + eax*8]
            //   eb05                 | jmp                 7
            //   b8????????           |                     
            //   f6400480             | test                byte ptr [eax + 4], 0x80

        $sequence_9 = { 890d???????? 8b0d???????? 68???????? a3???????? 68???????? 8d420c }
            // n = 6, score = 100
            //   890d????????         |                     
            //   8b0d????????         |                     
            //   68????????           |                     
            //   a3????????           |                     
            //   68????????           |                     
            //   8d420c               | lea                 eax, [edx + 0xc]

    condition:
        7 of them and filesize < 253952
}