rule win_scarecrow_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.scarecrow."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scarecrow"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c8fc 40 0f85e1010000 0f1f440000 ff45f4 8b45f4 2503000080 }
            // n = 7, score = 100
            //   83c8fc               | or                  eax, 0xfffffffc
            //   40                   | inc                 eax
            //   0f85e1010000         | jne                 0x1e7
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   ff45f4               | inc                 dword ptr [ebp - 0xc]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   2503000080           | and                 eax, 0x80000003

        $sequence_1 = { 51 57 ffd0 c6459c00 8bd8 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   57                   | push                edi
            //   ffd0                 | call                eax
            //   c6459c00             | mov                 byte ptr [ebp - 0x64], 0
            //   8bd8                 | mov                 ebx, eax

        $sequence_2 = { 8d427f 99 f7fb 885435f1 46 83fe0a 72d9 }
            // n = 7, score = 100
            //   8d427f               | lea                 eax, [edx + 0x7f]
            //   99                   | cdq                 
            //   f7fb                 | idiv                ebx
            //   885435f1             | mov                 byte ptr [ebp + esi - 0xf], dl
            //   46                   | inc                 esi
            //   83fe0a               | cmp                 esi, 0xa
            //   72d9                 | jb                  0xffffffdb

        $sequence_3 = { c68519feffff2d c6851afeffff37 c6851bfeffff32 c6851cfeffff37 c6851dfeffff26 c6851efeffff37 c6851ffeffff3b }
            // n = 7, score = 100
            //   c68519feffff2d       | mov                 byte ptr [ebp - 0x1e7], 0x2d
            //   c6851afeffff37       | mov                 byte ptr [ebp - 0x1e6], 0x37
            //   c6851bfeffff32       | mov                 byte ptr [ebp - 0x1e5], 0x32
            //   c6851cfeffff37       | mov                 byte ptr [ebp - 0x1e4], 0x37
            //   c6851dfeffff26       | mov                 byte ptr [ebp - 0x1e3], 0x26
            //   c6851efeffff37       | mov                 byte ptr [ebp - 0x1e2], 0x37
            //   c6851ffeffff3b       | mov                 byte ptr [ebp - 0x1e1], 0x3b

        $sequence_4 = { ff75e4 e8???????? 33c0 c745f807000000 668945e4 8945f4 8b451c }
            // n = 7, score = 100
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   c745f807000000       | mov                 dword ptr [ebp - 8], 7
            //   668945e4             | mov                 word ptr [ebp - 0x1c], ax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]

        $sequence_5 = { c645e603 c645e768 c645e852 c645e960 c645ea75 c645eb5a c645ec66 }
            // n = 7, score = 100
            //   c645e603             | mov                 byte ptr [ebp - 0x1a], 3
            //   c645e768             | mov                 byte ptr [ebp - 0x19], 0x68
            //   c645e852             | mov                 byte ptr [ebp - 0x18], 0x52
            //   c645e960             | mov                 byte ptr [ebp - 0x17], 0x60
            //   c645ea75             | mov                 byte ptr [ebp - 0x16], 0x75
            //   c645eb5a             | mov                 byte ptr [ebp - 0x15], 0x5a
            //   c645ec66             | mov                 byte ptr [ebp - 0x14], 0x66

        $sequence_6 = { 7463 8b8df0feffff 8d4303 03cf 0fafc8 898df0feffff 8b85f0feffff }
            // n = 7, score = 100
            //   7463                 | je                  0x65
            //   8b8df0feffff         | mov                 ecx, dword ptr [ebp - 0x110]
            //   8d4303               | lea                 eax, [ebx + 3]
            //   03cf                 | add                 ecx, edi
            //   0fafc8               | imul                ecx, eax
            //   898df0feffff         | mov                 dword ptr [ebp - 0x110], ecx
            //   8b85f0feffff         | mov                 eax, dword ptr [ebp - 0x110]

        $sequence_7 = { c6458e34 c6458f38 c6459034 c6459140 c6459234 c6459334 }
            // n = 6, score = 100
            //   c6458e34             | mov                 byte ptr [ebp - 0x72], 0x34
            //   c6458f38             | mov                 byte ptr [ebp - 0x71], 0x38
            //   c6459034             | mov                 byte ptr [ebp - 0x70], 0x34
            //   c6459140             | mov                 byte ptr [ebp - 0x6f], 0x40
            //   c6459234             | mov                 byte ptr [ebp - 0x6e], 0x34
            //   c6459334             | mov                 byte ptr [ebp - 0x6d], 0x34

        $sequence_8 = { c7461407000000 c7461000000000 66890e 8b5810 66390f 7414 8bcf }
            // n = 7, score = 100
            //   c7461407000000       | mov                 dword ptr [esi + 0x14], 7
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   66890e               | mov                 word ptr [esi], cx
            //   8b5810               | mov                 ebx, dword ptr [eax + 0x10]
            //   66390f               | cmp                 word ptr [edi], cx
            //   7414                 | je                  0x16
            //   8bcf                 | mov                 ecx, edi

        $sequence_9 = { c685a2f9ffff76 8a8595f9ffff 80bd94f9ffff00 7530 33f6 0f1f4000 }
            // n = 6, score = 100
            //   c685a2f9ffff76       | mov                 byte ptr [ebp - 0x65e], 0x76
            //   8a8595f9ffff         | mov                 al, byte ptr [ebp - 0x66b]
            //   80bd94f9ffff00       | cmp                 byte ptr [ebp - 0x66c], 0
            //   7530                 | jne                 0x32
            //   33f6                 | xor                 esi, esi
            //   0f1f4000             | nop                 dword ptr [eax]

    condition:
        7 of them and filesize < 501760
}