rule win_scote_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scote"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d95cffbffff b901040000 e8???????? 8b85a8fbffff b90f000000 33d2 e8???????? }
            // n = 7, score = 100
            //   8d95cffbffff         | lea                 edx, [ebp - 0x431]
            //   b901040000           | mov                 ecx, 0x401
            //   e8????????           |                     
            //   8b85a8fbffff         | mov                 eax, dword ptr [ebp - 0x458]
            //   b90f000000           | mov                 ecx, 0xf
            //   33d2                 | xor                 edx, edx
            //   e8????????           |                     

        $sequence_1 = { 84c0 7436 6a10 8d442404 50 }
            // n = 5, score = 100
            //   84c0                 | test                al, al
            //   7436                 | je                  0x38
            //   6a10                 | push                0x10
            //   8d442404             | lea                 eax, [esp + 4]
            //   50                   | push                eax

        $sequence_2 = { 52 50 8b4304 e8???????? e8???????? 8bd0 8bc5 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   50                   | push                eax
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   e8????????           |                     
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8bc5                 | mov                 eax, ebp

        $sequence_3 = { ff7580 68???????? ff75e0 68???????? ff75e4 }
            // n = 5, score = 100
            //   ff7580               | push                dword ptr [ebp - 0x80]
            //   68????????           |                     
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   68????????           |                     
            //   ff75e4               | push                dword ptr [ebp - 0x1c]

        $sequence_4 = { e8???????? ffb5c8fbffff 68???????? 8d45f0 ba03000000 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   ffb5c8fbffff         | push                dword ptr [ebp - 0x438]
            //   68????????           |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   ba03000000           | mov                 edx, 3

        $sequence_5 = { 8d45f8 e8???????? 8d4dec b2ff 8b45f4 }
            // n = 5, score = 100
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   e8????????           |                     
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   b2ff                 | mov                 dl, 0xff
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_6 = { 8b4010 894304 8b45fc 8b00 894308 8b45fc }
            // n = 6, score = 100
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   894308               | mov                 dword ptr [ebx + 8], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_7 = { 8b7878 85ff 0f84fb010000 83787c00 0f84f1010000 8bd7 8bc6 }
            // n = 7, score = 100
            //   8b7878               | mov                 edi, dword ptr [eax + 0x78]
            //   85ff                 | test                edi, edi
            //   0f84fb010000         | je                  0x201
            //   83787c00             | cmp                 dword ptr [eax + 0x7c], 0
            //   0f84f1010000         | je                  0x1f7
            //   8bd7                 | mov                 edx, edi
            //   8bc6                 | mov                 eax, esi

        $sequence_8 = { 8bc6 59 e8???????? 5f 5e 5b 59 }
            // n = 7, score = 100
            //   8bc6                 | mov                 eax, esi
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx

        $sequence_9 = { 50 8bcb 2bce 33d2 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8bcb                 | mov                 ecx, ebx
            //   2bce                 | sub                 ecx, esi
            //   33d2                 | xor                 edx, edx

    condition:
        7 of them and filesize < 155648
}