rule win_shapeshift_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.shapeshift."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shapeshift"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fbf05???????? 0fb680589a4100 884204 0fbf05???????? 0fb680589a4100 }
            // n = 5, score = 100
            //   0fbf05????????       |                     
            //   0fb680589a4100       | movzx               eax, byte ptr [eax + 0x419a58]
            //   884204               | mov                 byte ptr [edx + 4], al
            //   0fbf05????????       |                     
            //   0fb680589a4100       | movzx               eax, byte ptr [eax + 0x419a58]

        $sequence_1 = { 8bf8 83c404 b9???????? bb02000000 }
            // n = 4, score = 100
            //   8bf8                 | mov                 edi, eax
            //   83c404               | add                 esp, 4
            //   b9????????           |                     
            //   bb02000000           | mov                 ebx, 2

        $sequence_2 = { 8bf0 85f6 74b3 803d????????01 }
            // n = 4, score = 100
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   74b3                 | je                  0xffffffb5
            //   803d????????01       |                     

        $sequence_3 = { ffd7 51 8d85f8feffff 50 ff15???????? }
            // n = 5, score = 100
            //   ffd7                 | call                edi
            //   51                   | push                ecx
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_4 = { e8???????? 8904bd38054200 85c0 7514 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8904bd38054200       | mov                 dword ptr [edi*4 + 0x420538], eax
            //   85c0                 | test                eax, eax
            //   7514                 | jne                 0x16

        $sequence_5 = { 33d2 b93b110f00 f7f1 68???????? }
            // n = 4, score = 100
            //   33d2                 | xor                 edx, edx
            //   b93b110f00           | mov                 ecx, 0xf113b
            //   f7f1                 | div                 ecx
            //   68????????           |                     

        $sequence_6 = { 0f44f8 8d85fcfdffff 50 e8???????? 83c40c }
            // n = 5, score = 100
            //   0f44f8               | cmove               edi, eax
            //   8d85fcfdffff         | lea                 eax, [ebp - 0x204]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_7 = { ff15???????? 68???????? 6a00 ff15???????? 8bf0 ff15???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   68????????           |                     
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 303104
}