rule win_shimrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.shimrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shimrat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8bce e8???????? 85c0 742b 837dfc04 7518 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   742b                 | je                  0x2d
            //   837dfc04             | cmp                 dword ptr [ebp - 4], 4
            //   7518                 | jne                 0x1a

        $sequence_1 = { 85c0 7409 ff7570 e8???????? }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   ff7570               | push                dword ptr [ebp + 0x70]
            //   e8????????           |                     

        $sequence_2 = { 5e c3 33c0 8901 894104 894108 c3 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   8901                 | mov                 dword ptr [ecx], eax
            //   894104               | mov                 dword ptr [ecx + 4], eax
            //   894108               | mov                 dword ptr [ecx + 8], eax
            //   c3                   | ret                 

        $sequence_3 = { 0f8416010000 8d8e90000000 e8???????? 50 8d8e90000000 }
            // n = 5, score = 100
            //   0f8416010000         | je                  0x11c
            //   8d8e90000000         | lea                 ecx, [esi + 0x90]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d8e90000000         | lea                 ecx, [esi + 0x90]

        $sequence_4 = { 85c0 75ca 8b07 881c06 8b4514 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   75ca                 | jne                 0xffffffcc
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   881c06               | mov                 byte ptr [esi + eax], bl
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_5 = { 50 e8???????? 83c414 50 8d4f6c e8???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   50                   | push                eax
            //   8d4f6c               | lea                 ecx, [edi + 0x6c]
            //   e8????????           |                     

        $sequence_6 = { 8b35???????? 83c40c 395dd8 7405 ff75d8 }
            // n = 5, score = 100
            //   8b35????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   395dd8               | cmp                 dword ptr [ebp - 0x28], ebx
            //   7405                 | je                  7
            //   ff75d8               | push                dword ptr [ebp - 0x28]

        $sequence_7 = { 0f84a4000000 6a7f 8d45d8 50 ff7560 }
            // n = 5, score = 100
            //   0f84a4000000         | je                  0xaa
            //   6a7f                 | push                0x7f
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   ff7560               | push                dword ptr [ebp + 0x60]

        $sequence_8 = { e8???????? 85c0 0f8488000000 8d4d34 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8488000000         | je                  0x8e
            //   8d4d34               | lea                 ecx, [ebp + 0x34]

        $sequence_9 = { ff7560 ffd6 e9???????? 53 ebd0 8d4d28 e8???????? }
            // n = 7, score = 100
            //   ff7560               | push                dword ptr [ebp + 0x60]
            //   ffd6                 | call                esi
            //   e9????????           |                     
            //   53                   | push                ebx
            //   ebd0                 | jmp                 0xffffffd2
            //   8d4d28               | lea                 ecx, [ebp + 0x28]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 65536
}