rule win_sidewinder_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sidewinder."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sidewinder"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 50 e8???????? 8bd0 8d4de8 e8???????? 8d45c8 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   e8????????           |                     
            //   8d45c8               | lea                 eax, [ebp - 0x38]

        $sequence_1 = { 8d4dc4 e8???????? 8d45ac 89458c 8d458c 50 }
            // n = 6, score = 200
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   e8????????           |                     
            //   8d45ac               | lea                 eax, [ebp - 0x54]
            //   89458c               | mov                 dword ptr [ebp - 0x74], eax
            //   8d458c               | lea                 eax, [ebp - 0x74]
            //   50                   | push                eax

        $sequence_2 = { 8d4dcc e8???????? 8d45dc 898570ffffff c78568ffffff08400000 8d8568ffffff 50 }
            // n = 7, score = 200
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   e8????????           |                     
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   898570ffffff         | mov                 dword ptr [ebp - 0x90], eax
            //   c78568ffffff08400000     | mov    dword ptr [ebp - 0x98], 0x4008
            //   8d8568ffffff         | lea                 eax, [ebp - 0x98]
            //   50                   | push                eax

        $sequence_3 = { 8965ec c745f0182c4000 c745f400000000 c745f800000000 6a01 e8???????? 8d45dc }
            // n = 7, score = 200
            //   8965ec               | mov                 dword ptr [ebp - 0x14], esp
            //   c745f0182c4000       | mov                 dword ptr [ebp - 0x10], 0x402c18
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   6a01                 | push                1
            //   e8????????           |                     
            //   8d45dc               | lea                 eax, [ebp - 0x24]

        $sequence_4 = { ff75bc 8b45cc 8b00 ff75cc ff5060 dbe2 8945b4 }
            // n = 7, score = 200
            //   ff75bc               | push                dword ptr [ebp - 0x44]
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ff75cc               | push                dword ptr [ebp - 0x34]
            //   ff5060               | call                dword ptr [eax + 0x60]
            //   dbe2                 | fnclex              
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax

        $sequence_5 = { ff5004 8b4508 8b403c 0b450c 8b4d08 89413c 8b4508 }
            // n = 7, score = 200
            //   ff5004               | call                dword ptr [eax + 4]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b403c               | mov                 eax, dword ptr [eax + 0x3c]
            //   0b450c               | or                  eax, dword ptr [ebp + 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   89413c               | mov                 dword ptr [ecx + 0x3c], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_6 = { 0f8053010000 668945ec 668b45ec 663b45d8 0f8f22010000 668365e400 }
            // n = 6, score = 200
            //   0f8053010000         | jo                  0x159
            //   668945ec             | mov                 word ptr [ebp - 0x14], ax
            //   668b45ec             | mov                 ax, word ptr [ebp - 0x14]
            //   663b45d8             | cmp                 ax, word ptr [ebp - 0x28]
            //   0f8f22010000         | jg                  0x128
            //   668365e400           | and                 word ptr [ebp - 0x1c], 0

        $sequence_7 = { 0f84df000000 66830d????????ff 8d45dc 50 8b45e8 8b00 ff75e8 }
            // n = 7, score = 200
            //   0f84df000000         | je                  0xe5
            //   66830d????????ff     |                     
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ff75e8               | push                dword ptr [ebp - 0x18]

        $sequence_8 = { e8???????? 898530ffffff eb07 83a530ffffff00 6a00 8b8568ffffff 83e801 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   898530ffffff         | mov                 dword ptr [ebp - 0xd0], eax
            //   eb07                 | jmp                 9
            //   83a530ffffff00       | and                 dword ptr [ebp - 0xd0], 0
            //   6a00                 | push                0
            //   8b8568ffffff         | mov                 eax, dword ptr [ebp - 0x98]
            //   83e801               | sub                 eax, 1

        $sequence_9 = { e8???????? 68???????? 8d4ddc e8???????? 8d4dd8 e8???????? c3 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 679936
}