rule win_simda_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.simda."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.simda"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f906 7519 8b85e8feffff 85c0 }
            // n = 4, score = 700
            //   83f906               | cmp                 ecx, 6
            //   7519                 | jne                 0x1b
            //   8b85e8feffff         | mov                 eax, dword ptr [ebp - 0x118]
            //   85c0                 | test                eax, eax

        $sequence_1 = { 0faffe 8bd0 0faf55fc 8bd9 8bf7 c1e610 c1e110 }
            // n = 7, score = 700
            //   0faffe               | imul                edi, esi
            //   8bd0                 | mov                 edx, eax
            //   0faf55fc             | imul                edx, dword ptr [ebp - 4]
            //   8bd9                 | mov                 ebx, ecx
            //   8bf7                 | mov                 esi, edi
            //   c1e610               | shl                 esi, 0x10
            //   c1e110               | shl                 ecx, 0x10

        $sequence_2 = { 8b85e8feffff 85c0 7505 8d41ff eb0f 83f801 }
            // n = 6, score = 700
            //   8b85e8feffff         | mov                 eax, dword ptr [ebp - 0x118]
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   8d41ff               | lea                 eax, [ecx - 1]
            //   eb0f                 | jmp                 0x11
            //   83f801               | cmp                 eax, 1

        $sequence_3 = { 56 ff15???????? 8b4d08 6a00 8d45fc }
            // n = 5, score = 700
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   6a00                 | push                0
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_4 = { 8b7510 57 e8???????? 57 8bf3 e8???????? }
            // n = 6, score = 700
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   57                   | push                edi
            //   e8????????           |                     
            //   57                   | push                edi
            //   8bf3                 | mov                 esi, ebx
            //   e8????????           |                     

        $sequence_5 = { 7601 48 8bd1 c1ea10 }
            // n = 4, score = 700
            //   7601                 | jbe                 3
            //   48                   | dec                 eax
            //   8bd1                 | mov                 edx, ecx
            //   c1ea10               | shr                 edx, 0x10

        $sequence_6 = { 3bd0 7301 41 8b4508 0faff3 03f1 }
            // n = 6, score = 700
            //   3bd0                 | cmp                 edx, eax
            //   7301                 | jae                 3
            //   41                   | inc                 ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0faff3               | imul                esi, ebx
            //   03f1                 | add                 esi, ecx

        $sequence_7 = { 33d2 bb06000000 f7f3 8a5415f0 }
            // n = 4, score = 700
            //   33d2                 | xor                 edx, edx
            //   bb06000000           | mov                 ebx, 6
            //   f7f3                 | div                 ebx
            //   8a5415f0             | mov                 dl, byte ptr [ebp + edx - 0x10]

        $sequence_8 = { 8b38 f7d9 3b3c18 7301 41 }
            // n = 5, score = 700
            //   8b38                 | mov                 edi, dword ptr [eax]
            //   f7d9                 | neg                 ecx
            //   3b3c18               | cmp                 edi, dword ptr [eax + ebx]
            //   7301                 | jae                 3
            //   41                   | inc                 ecx

        $sequence_9 = { 85c0 75dd 8b4d0c 8bc3 2bc2 }
            // n = 5, score = 700
            //   85c0                 | test                eax, eax
            //   75dd                 | jne                 0xffffffdf
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8bc3                 | mov                 eax, ebx
            //   2bc2                 | sub                 eax, edx

    condition:
        7 of them and filesize < 1581056
}