rule win_simplefilemover_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.simplefilemover."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.simplefilemover"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bfc f3a5 e8???????? 81c420020000 }
            // n = 4, score = 500
            //   8bfc                 | mov                 edi, esp
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   e8????????           |                     
            //   81c420020000         | add                 esp, 0x220

        $sequence_1 = { 7d07 33c0 e9???????? 6820020000 }
            // n = 4, score = 400
            //   7d07                 | jge                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   6820020000           | push                0x220

        $sequence_2 = { e8???????? 81c420020000 85c0 7407 68???????? eb05 68???????? }
            // n = 7, score = 300
            //   e8????????           |                     
            //   81c420020000         | add                 esp, 0x220
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   68????????           |                     
            //   eb05                 | jmp                 7
            //   68????????           |                     

        $sequence_3 = { b988000000 8bf3 8bfc f3a5 }
            // n = 4, score = 300
            //   b988000000           | mov                 ecx, 0x88
            //   8bf3                 | mov                 esi, ebx
            //   8bfc                 | mov                 edi, esp
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_4 = { ffd6 8bf8 3bfb 7462 }
            // n = 4, score = 200
            //   ffd6                 | call                esi
            //   8bf8                 | mov                 edi, eax
            //   3bfb                 | cmp                 edi, ebx
            //   7462                 | je                  0x64

        $sequence_5 = { 59 8d45e8 59 53 50 }
            // n = 5, score = 200
            //   59                   | pop                 ecx
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   59                   | pop                 ecx
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_6 = { 51 ff15???????? 6a00 6800200000 8d9554daffff 52 8b8554faffff }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6800200000           | push                0x2000
            //   8d9554daffff         | lea                 edx, [ebp - 0x25ac]
            //   52                   | push                edx
            //   8b8554faffff         | mov                 eax, dword ptr [ebp - 0x5ac]

        $sequence_7 = { 5f 889000010000 888801010000 5e 83c410 }
            // n = 5, score = 200
            //   5f                   | pop                 edi
            //   889000010000         | mov                 byte ptr [eax + 0x100], dl
            //   888801010000         | mov                 byte ptr [eax + 0x101], cl
            //   5e                   | pop                 esi
            //   83c410               | add                 esp, 0x10

        $sequence_8 = { 750f c78508daffff00000000 e9???????? 6a04 8d8d54daffff }
            // n = 5, score = 200
            //   750f                 | jne                 0x11
            //   c78508daffff00000000     | mov    dword ptr [ebp - 0x25f8], 0
            //   e9????????           |                     
            //   6a04                 | push                4
            //   8d8d54daffff         | lea                 ecx, [ebp - 0x25ac]

        $sequence_9 = { ebc0 ebbe ebbc ebba ebb8 ebb6 5f }
            // n = 7, score = 200
            //   ebc0                 | jmp                 0xffffffc2
            //   ebbe                 | jmp                 0xffffffc0
            //   ebbc                 | jmp                 0xffffffbe
            //   ebba                 | jmp                 0xffffffbc
            //   ebb8                 | jmp                 0xffffffba
            //   ebb6                 | jmp                 0xffffffb8
            //   5f                   | pop                 edi

        $sequence_10 = { 6a00 8b8508daffff 2b85fcd9ffff 50 8b8d04daffff }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   8b8508daffff         | mov                 eax, dword ptr [ebp - 0x25f8]
            //   2b85fcd9ffff         | sub                 eax, dword ptr [ebp - 0x2604]
            //   50                   | push                eax
            //   8b8d04daffff         | mov                 ecx, dword ptr [ebp - 0x25fc]

        $sequence_11 = { f7ff 0fb6c2 8945f0 03c1 8855ff 8a10 88140e }
            // n = 7, score = 200
            //   f7ff                 | idiv                edi
            //   0fb6c2               | movzx               eax, dl
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   03c1                 | add                 eax, ecx
            //   8855ff               | mov                 byte ptr [ebp - 1], dl
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   88140e               | mov                 byte ptr [esi + ecx], dl

        $sequence_12 = { 8b74241c 57 8a8800010000 8a9001010000 33ff 884c2408 }
            // n = 6, score = 200
            //   8b74241c             | mov                 esi, dword ptr [esp + 0x1c]
            //   57                   | push                edi
            //   8a8800010000         | mov                 cl, byte ptr [eax + 0x100]
            //   8a9001010000         | mov                 dl, byte ptr [eax + 0x101]
            //   33ff                 | xor                 edi, edi
            //   884c2408             | mov                 byte ptr [esp + 8], cl

        $sequence_13 = { 85c0 7407 33c0 e9???????? 6a00 6a01 6a02 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6a02                 | push                2

        $sequence_14 = { 85f6 7417 8b4c2414 8d447b02 50 }
            // n = 5, score = 200
            //   85f6                 | test                esi, esi
            //   7417                 | je                  0x19
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8d447b02             | lea                 eax, [ebx + edi*2 + 2]
            //   50                   | push                eax

        $sequence_15 = { 8a9001010000 33ff 884c2408 3bf7 88542424 897c2410 }
            // n = 6, score = 200
            //   8a9001010000         | mov                 dl, byte ptr [eax + 0x101]
            //   33ff                 | xor                 edi, edi
            //   884c2408             | mov                 byte ptr [esp + 8], cl
            //   3bf7                 | cmp                 esi, edi
            //   88542424             | mov                 byte ptr [esp + 0x24], dl
            //   897c2410             | mov                 dword ptr [esp + 0x10], edi

        $sequence_16 = { 8b5c2408 56 57 668b03 33d2 33f6 33ff }
            // n = 7, score = 200
            //   8b5c2408             | mov                 ebx, dword ptr [esp + 8]
            //   56                   | push                esi
            //   57                   | push                edi
            //   668b03               | mov                 ax, word ptr [ebx]
            //   33d2                 | xor                 edx, edx
            //   33f6                 | xor                 esi, esi
            //   33ff                 | xor                 edi, edi

        $sequence_17 = { 8b4c2410 81e1ff000000 8a1c01 885c241c }
            // n = 4, score = 200
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   81e1ff000000         | and                 ecx, 0xff
            //   8a1c01               | mov                 bl, byte ptr [ecx + eax]
            //   885c241c             | mov                 byte ptr [esp + 0x1c], bl

        $sequence_18 = { 83c10c 51 8d9554daffff 52 e8???????? 83c408 6a00 }
            // n = 7, score = 200
            //   83c10c               | add                 ecx, 0xc
            //   51                   | push                ecx
            //   8d9554daffff         | lea                 edx, [ebp - 0x25ac]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6a00                 | push                0

        $sequence_19 = { 3bf8 7426 8d4dd4 53 51 8bcf 2bc8 }
            // n = 7, score = 200
            //   3bf8                 | cmp                 edi, eax
            //   7426                 | je                  0x28
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   8bcf                 | mov                 ecx, edi
            //   2bc8                 | sub                 ecx, eax

        $sequence_20 = { 3bfb 0f8c54ffffff 8a4c242c 5d 5b }
            // n = 5, score = 200
            //   3bfb                 | cmp                 edi, ebx
            //   0f8c54ffffff         | jl                  0xffffff5a
            //   8a4c242c             | mov                 cl, byte ptr [esp + 0x2c]
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx

        $sequence_21 = { 42 6685c0 75ea 85f6 }
            // n = 4, score = 200
            //   42                   | inc                 edx
            //   6685c0               | test                ax, ax
            //   75ea                 | jne                 0xffffffec
            //   85f6                 | test                esi, esi

    condition:
        7 of them and filesize < 57344
}