rule win_sisfader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sisfader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sisfader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c9 741f 33c0 85c9 7419 }
            // n = 5, score = 300
            //   85c9                 | test                ecx, ecx
            //   741f                 | je                  0x21
            //   33c0                 | xor                 eax, eax
            //   85c9                 | test                ecx, ecx
            //   7419                 | je                  0x1b

        $sequence_1 = { e8???????? 85c0 b91d000000 0f44d9 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   b91d000000           | mov                 ecx, 0x1d
            //   0f44d9               | cmove               ebx, ecx

        $sequence_2 = { 33d2 b901000000 e8???????? eb67 }
            // n = 4, score = 200
            //   33d2                 | xor                 edx, edx
            //   b901000000           | mov                 ecx, 1
            //   e8????????           |                     
            //   eb67                 | jmp                 0x69

        $sequence_3 = { 83c801 8945f0 8b4df0 894de4 }
            // n = 4, score = 200
            //   83c801               | or                  eax, 1
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx

        $sequence_4 = { 53 56 57 6810010000 6a40 }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   6810010000           | push                0x110
            //   6a40                 | push                0x40

        $sequence_5 = { 81eca8010000 8d855cfeffff 53 56 }
            // n = 4, score = 200
            //   81eca8010000         | sub                 esp, 0x1a8
            //   8d855cfeffff         | lea                 eax, [ebp - 0x1a4]
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_6 = { 8b040a 50 ff15???????? a3???????? }
            // n = 4, score = 200
            //   8b040a               | mov                 eax, dword ptr [edx + ecx]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   a3????????           |                     

        $sequence_7 = { 33c9 0f8543ffffff 8b55f8 52 ff15???????? 8be5 }
            // n = 6, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   0f8543ffffff         | jne                 0xffffff49
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8be5                 | mov                 esp, ebp

        $sequence_8 = { 8906 8b442470 89442440 8b44246c }
            // n = 4, score = 200
            //   8906                 | mov                 dword ptr [esi], eax
            //   8b442470             | mov                 eax, dword ptr [esp + 0x70]
            //   89442440             | mov                 dword ptr [esp + 0x40], eax
            //   8b44246c             | mov                 eax, dword ptr [esp + 0x6c]

        $sequence_9 = { 837c242001 7402 eb05 e8???????? b801000000 }
            // n = 5, score = 200
            //   837c242001           | cmp                 dword ptr [esp + 0x20], 1
            //   7402                 | je                  4
            //   eb05                 | jmp                 7
            //   e8????????           |                     
            //   b801000000           | mov                 eax, 1

        $sequence_10 = { 8b442430 8905???????? c705????????07000000 8b442438 8905???????? c705????????00000000 8b442440 }
            // n = 7, score = 200
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]
            //   8905????????         |                     
            //   c705????????07000000     |     
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   8905????????         |                     
            //   c705????????00000000     |     
            //   8b442440             | mov                 eax, dword ptr [esp + 0x40]

        $sequence_11 = { 6a00 6a00 6a01 e8???????? 83c40c eb38 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb38                 | jmp                 0x3a

        $sequence_12 = { c705????????00000000 6a01 6a00 6a02 e8???????? }
            // n = 5, score = 200
            //   c705????????00000000     |     
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   e8????????           |                     

        $sequence_13 = { 837c242003 745d 837c242004 7479 837c242005 }
            // n = 5, score = 200
            //   837c242003           | cmp                 dword ptr [esp + 0x20], 3
            //   745d                 | je                  0x5f
            //   837c242004           | cmp                 dword ptr [esp + 0x20], 4
            //   7479                 | je                  0x7b
            //   837c242005           | cmp                 dword ptr [esp + 0x20], 5

        $sequence_14 = { 0fb74816 81e100200000 7409 c745d801000000 }
            // n = 4, score = 200
            //   0fb74816             | movzx               ecx, word ptr [eax + 0x16]
            //   81e100200000         | and                 ecx, 0x2000
            //   7409                 | je                  0xb
            //   c745d801000000       | mov                 dword ptr [ebp - 0x28], 1

        $sequence_15 = { 7e08 03d8 3bdf 7c98 }
            // n = 4, score = 200
            //   7e08                 | jle                 0xa
            //   03d8                 | add                 ebx, eax
            //   3bdf                 | cmp                 ebx, edi
            //   7c98                 | jl                  0xffffff9a

        $sequence_16 = { 0f108f48010000 0f110d???????? 0f10872e010000 0f118600010000 ff15???????? }
            // n = 5, score = 200
            //   0f108f48010000       | movups              xmm1, xmmword ptr [edi + 0x148]
            //   0f110d????????       |                     
            //   0f10872e010000       | movups              xmm0, xmmword ptr [edi + 0x12e]
            //   0f118600010000       | movups              xmmword ptr [esi + 0x100], xmm0
            //   ff15????????         |                     

        $sequence_17 = { 83c418 b842000000 6bc800 8b5510 0fb7440a40 }
            // n = 5, score = 200
            //   83c418               | add                 esp, 0x18
            //   b842000000           | mov                 eax, 0x42
            //   6bc800               | imul                ecx, eax, 0
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   0fb7440a40           | movzx               eax, word ptr [edx + ecx + 0x40]

        $sequence_18 = { 7411 6683f92e 7509 66399db0010000 7402 ffc7 }
            // n = 6, score = 200
            //   7411                 | je                  0x13
            //   6683f92e             | cmp                 cx, 0x2e
            //   7509                 | jne                 0xb
            //   66399db0010000       | cmp                 word ptr [ebp + 0x1b0], bx
            //   7402                 | je                  4
            //   ffc7                 | inc                 edi

        $sequence_19 = { e8???????? 33c0 83f801 7425 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   83f801               | cmp                 eax, 1
            //   7425                 | je                  0x27

        $sequence_20 = { 5d c3 8b450c b986000000 56 57 6a00 }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   b986000000           | mov                 ecx, 0x86
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a00                 | push                0

        $sequence_21 = { c3 b82b050000 5f 5e 5b }
            // n = 5, score = 200
            //   c3                   | ret                 
            //   b82b050000           | mov                 eax, 0x52b
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_22 = { 89442420 837c242001 7425 837c242002 7441 837c242003 745d }
            // n = 7, score = 200
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   837c242001           | cmp                 dword ptr [esp + 0x20], 1
            //   7425                 | je                  0x27
            //   837c242002           | cmp                 dword ptr [esp + 0x20], 2
            //   7441                 | je                  0x43
            //   837c242003           | cmp                 dword ptr [esp + 0x20], 3
            //   745d                 | je                  0x5f

        $sequence_23 = { 89442450 837c245000 7405 e9???????? 83bc248000000000 7539 }
            // n = 6, score = 200
            //   89442450             | mov                 dword ptr [esp + 0x50], eax
            //   837c245000           | cmp                 dword ptr [esp + 0x50], 0
            //   7405                 | je                  7
            //   e9????????           |                     
            //   83bc248000000000     | cmp                 dword ptr [esp + 0x80], 0
            //   7539                 | jne                 0x3b

        $sequence_24 = { 0f108348010000 0f1105???????? 0f10832e010000 0f1187e0000000 ff15???????? 8bf0 8d9ff0000000 }
            // n = 7, score = 200
            //   0f108348010000       | movups              xmm0, xmmword ptr [ebx + 0x148]
            //   0f1105????????       |                     
            //   0f10832e010000       | movups              xmm0, xmmword ptr [ebx + 0x12e]
            //   0f1187e0000000       | movups              xmmword ptr [edi + 0xe0], xmm0
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8d9ff0000000         | lea                 ebx, [edi + 0xf0]

        $sequence_25 = { eb12 c744245401000000 33c0 85c0 0f850fffffff }
            // n = 5, score = 200
            //   eb12                 | jmp                 0x14
            //   c744245401000000     | mov                 dword ptr [esp + 0x54], 1
            //   33c0                 | xor                 eax, eax
            //   85c0                 | test                eax, eax
            //   0f850fffffff         | jne                 0xffffff15

        $sequence_26 = { c744240cdcff0000 740c b818000000 5f }
            // n = 4, score = 200
            //   c744240cdcff0000     | mov                 dword ptr [esp + 0xc], 0xffdc
            //   740c                 | je                  0xe
            //   b818000000           | mov                 eax, 0x18
            //   5f                   | pop                 edi

        $sequence_27 = { 8b45ec 50 8b4dd4 51 e8???????? }
            // n = 5, score = 200
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   50                   | push                eax
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_28 = { 7464 6683bdcc0100002e 751c 0fb785ce010000 }
            // n = 4, score = 200
            //   7464                 | je                  0x66
            //   6683bdcc0100002e     | cmp                 word ptr [ebp + 0x1cc], 0x2e
            //   751c                 | jne                 0x1e
            //   0fb785ce010000       | movzx               eax, word ptr [ebp + 0x1ce]

        $sequence_29 = { 894708 817908020f0000 0f8573010000 83790410 c7442470dcff0000 740d }
            // n = 6, score = 200
            //   894708               | mov                 dword ptr [edi + 8], eax
            //   817908020f0000       | cmp                 dword ptr [ecx + 8], 0xf02
            //   0f8573010000         | jne                 0x179
            //   83790410             | cmp                 dword ptr [ecx + 4], 0x10
            //   c7442470dcff0000     | mov                 dword ptr [esp + 0x70], 0xffdc
            //   740d                 | je                  0xf

    condition:
        7 of them and filesize < 417792
}