rule win_skinnyboy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.skinnyboy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.skinnyboy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 888158050110 41 ebe8 8975e0 }
            // n = 4, score = 100
            //   888158050110         | mov                 byte ptr [ecx + 0x10010558], al
            //   41                   | inc                 ecx
            //   ebe8                 | jmp                 0xffffffea
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi

        $sequence_1 = { 8d8560fdffff 50 8d8558fbffff 50 }
            // n = 4, score = 100
            //   8d8560fdffff         | lea                 eax, [ebp - 0x2a0]
            //   50                   | push                eax
            //   8d8558fbffff         | lea                 eax, [ebp - 0x4a8]
            //   50                   | push                eax

        $sequence_2 = { 8975fc 8b45e0 8b048510110110 f644030401 }
            // n = 4, score = 100
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8b048510110110       | mov                 eax, dword ptr [eax*4 + 0x10011110]
            //   f644030401           | test                byte ptr [ebx + eax + 4], 1

        $sequence_3 = { 837de416 7426 8d45e0 50 ff15???????? 8d45e0 50 }
            // n = 7, score = 100
            //   837de416             | cmp                 dword ptr [ebp - 0x1c], 0x16
            //   7426                 | je                  0x28
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax

        $sequence_4 = { 8d8df0feffff e8???????? 83c408 8d5508 8d8de4feffff }
            // n = 5, score = 100
            //   8d8df0feffff         | lea                 ecx, [ebp - 0x110]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d5508               | lea                 edx, [ebp + 8]
            //   8d8de4feffff         | lea                 ecx, [ebp - 0x11c]

        $sequence_5 = { c78578ffffff01591244 c7857cffffff09020f1c c745804a6a2362 c7458413051f17 c6458853 }
            // n = 5, score = 100
            //   c78578ffffff01591244     | mov    dword ptr [ebp - 0x88], 0x44125901
            //   c7857cffffff09020f1c     | mov    dword ptr [ebp - 0x84], 0x1c0f0209
            //   c745804a6a2362       | mov                 dword ptr [ebp - 0x80], 0x62236a4a
            //   c7458413051f17       | mov                 dword ptr [ebp - 0x7c], 0x171f0513
            //   c6458853             | mov                 byte ptr [ebp - 0x78], 0x53

        $sequence_6 = { 8bf7 83e61f c1e606 03348510110110 837e0800 7530 }
            // n = 6, score = 100
            //   8bf7                 | mov                 esi, edi
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   03348510110110       | add                 esi, dword ptr [eax*4 + 0x10011110]
            //   837e0800             | cmp                 dword ptr [esi + 8], 0
            //   7530                 | jne                 0x32

        $sequence_7 = { ffd7 50 ffd6 6800dd6d00 ff35???????? }
            // n = 5, score = 100
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   6800dd6d00           | push                0x6ddd00
            //   ff35????????         |                     

        $sequence_8 = { 8b9dd4feffff 8b85e4feffff 53 50 8d8dd8feffff e8???????? }
            // n = 6, score = 100
            //   8b9dd4feffff         | mov                 ebx, dword ptr [ebp - 0x12c]
            //   8b85e4feffff         | mov                 eax, dword ptr [ebp - 0x11c]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8d8dd8feffff         | lea                 ecx, [ebp - 0x128]
            //   e8????????           |                     

        $sequence_9 = { 8d45f4 50 ff7308 ff15???????? 8b15???????? 85c0 }
            // n = 6, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   ff7308               | push                dword ptr [ebx + 8]
            //   ff15????????         |                     
            //   8b15????????         |                     
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 176128
}