rule win_skip20_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.skip20."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.skip20"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740d ffc9 75bf 0fb705???????? eb10 0fb705???????? }
            // n = 6, score = 200
            //   740d                 | inc                 ecx
            //   ffc9                 | cmp                 bl, 2
            //   75bf                 | jne                 0x11
            //   0fb705????????       |                     
            //   eb10                 | je                  0xf
            //   0fb705????????       |                     

        $sequence_1 = { 8b15???????? 85d2 7430 8bc7 488d0dfe000200 }
            // n = 5, score = 200
            //   8b15????????         |                     
            //   85d2                 | lea                 ecx, [0xffffda3c]
            //   7430                 | dec                 eax
            //   8bc7                 | lea                 ecx, [0xffffdb50]
            //   488d0dfe000200       | movzx               ecx, word ptr [eax + 4]

        $sequence_2 = { b22a 488bcb e8???????? 440fb65f35 4180fb02 750f }
            // n = 6, score = 200
            //   b22a                 | mov                 dl, 0x2a
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   440fb65f35           | mov                 ecx, ebx
            //   4180fb02             | inc                 esp
            //   750f                 | movzx               ebx, byte ptr [edi + 0x35]

        $sequence_3 = { 0fb74804 66890b 4883451006 e9???????? 4183fe28 7529 }
            // n = 6, score = 200
            //   0fb74804             | mov                 edx, dword ptr [eax + ecx + 0x24]
            //   66890b               | dec                 eax
            //   4883451006           | add                 edx, ebx
            //   e9????????           |                     
            //   4183fe28             | mov                 edi, dword ptr [eax + ecx + 0x20]
            //   7529                 | dec                 eax

        $sequence_4 = { 7516 48634b3c 4803cb 0fb74114 8b540824 4803d3 8b7c0820 }
            // n = 7, score = 200
            //   7516                 | dec                 ecx
            //   48634b3c             | jne                 0xffffffc3
            //   4803cb               | jmp                 0x16
            //   0fb74114             | jne                 0x18
            //   8b540824             | dec                 eax
            //   4803d3               | arpl                word ptr [ebx + 0x3c], cx
            //   8b7c0820             | dec                 eax

        $sequence_5 = { e8???????? 488d0d3cdaffff e8???????? 488d0d50dbffff e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   488d0d3cdaffff       | add                 ecx, ebx
            //   e8????????           |                     
            //   488d0d50dbffff       | movzx               eax, word ptr [ecx + 0x14]
            //   e8????????           |                     

        $sequence_6 = { c7842418010000ec586548 c784241c0100008b042530 664489ac2420010000 4488ac2422010000 }
            // n = 4, score = 200
            //   c7842418010000ec586548     | inc    ecx
            //   c784241c0100008b042530     | cmp    esi, 0x28
            //   664489ac2420010000     | jne    0x2f
            //   4488ac2422010000     | test                edx, edx

        $sequence_7 = { 8b0d???????? 488bd8 ff15???????? 4883fb01 7466 }
            // n = 5, score = 200
            //   8b0d????????         |                     
            //   488bd8               | mov                 word ptr [ebx], cx
            //   ff15????????         |                     
            //   4883fb01             | dec                 eax
            //   7466                 | add                 dword ptr [ebp + 0x10], 6

    condition:
        7 of them and filesize < 794624
}