rule win_skipper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.skipper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.skipper"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6a00 6a03 68???????? 68???????? 6a50 }
            // n = 6, score = 600
            //   6a00                 | inc                 edx
            //   6a00                 | movzx               eax, byte ptr [edx + esi]
            //   6a03                 | inc                 esp
            //   68????????           |                     
            //   68????????           |                     
            //   6a50                 | add                 eax, eax

        $sequence_1 = { e8???????? 6804010000 e8???????? 6804010000 8bf8 6a00 }
            // n = 6, score = 500
            //   e8????????           |                     
            //   6804010000           | add                 ecx, dword ptr [ebp - 0x118]
            //   e8????????           |                     
            //   6804010000           | mov                 eax, dword ptr [ebp - 0x120]
            //   8bf8                 | cdq                 
            //   6a00                 | idiv                dword ptr [ebp + 0xc]

        $sequence_2 = { ff15???????? 6a00 6a00 6a00 6a00 50 ff15???????? }
            // n = 7, score = 500
            //   ff15????????         |                     
            //   6a00                 | inc                 ebp
            //   6a00                 | movzx               ecx, byte ptr [eax]
            //   6a00                 | inc                 ecx
            //   6a00                 | dec                 edx
            //   50                   | inc                 ecx
            //   ff15????????         |                     

        $sequence_3 = { 6800803801 6a00 ff37 e8???????? 6804010000 c7470400000000 }
            // n = 6, score = 400
            //   6800803801           | jb                  0xfffffff7
            //   6a00                 | je                  0x3e
            //   ff37                 | mov                 esi, dword ptr [ebp - 0x20]
            //   e8????????           |                     
            //   6804010000           | mov                 eax, esi
            //   c7470400000000       | sar                 eax, 5

        $sequence_4 = { 0fb6c1 8b4d08 0fb68405fcfeffff 320439 }
            // n = 4, score = 400
            //   0fb6c1               | je                  0x12
            //   8b4d08               | inc                 edi
            //   0fb68405fcfeffff     | mov                 dword ptr [ebp - 4], edi
            //   320439               | cmp                 edi, 0x17

        $sequence_5 = { 6804010000 6a00 50 8945e0 e8???????? }
            // n = 5, score = 400
            //   6804010000           | inc                 eax
            //   6a00                 | jmp                 0xffffffef
            //   50                   | lea                 ecx, [ecx*4 + 0x23b720]
            //   8945e0               | mov                 dword ptr [ecx], eax
            //   e8????????           |                     

        $sequence_6 = { 0fb68405fcfeffff 320439 47 8847ff 4e 0f8568ffffff 8b4dfc }
            // n = 7, score = 400
            //   0fb68405fcfeffff     | mov                 eax, dword ptr [ebp + 8]
            //   320439               | push                eax
            //   47                   | push                0
            //   8847ff               | mov                 ecx, dword ptr [ebp - 0x12c]
            //   4e                   | push                ecx
            //   0f8568ffffff         | mov                 cl, byte ptr [eax + ebx + 0x11d]
            //   8b4dfc               | mov                 byte ptr [eax + 0x23a5b0], cl

        $sequence_7 = { 0385f8feffff 898df4feffff 25ff000080 7907 48 0d00ffffff }
            // n = 6, score = 400
            //   0385f8feffff         | push                0
            //   898df4feffff         | push                eax
            //   25ff000080           | push                0
            //   7907                 | push                0
            //   48                   | push                0
            //   0d00ffffff           | push                0

        $sequence_8 = { e8???????? 83c404 6a00 6a64 52 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   83c404               | inc                 ecx
            //   6a00                 | dec                 eax
            //   6a64                 | inc                 eax
            //   52                   | dec                 eax

        $sequence_9 = { 6800308000 6a00 6a00 68???????? }
            // n = 4, score = 300
            //   6800308000           | push                0
            //   6a00                 | push                0
            //   6a00                 | push                eax
            //   68????????           |                     

        $sequence_10 = { 038de8feffff 8b85e0feffff 99 f77d0c 8b4508 }
            // n = 5, score = 200
            //   038de8feffff         | dec                 eax
            //   8b85e0feffff         | dec                 ebx
            //   99                   | jne                 0xffffff82
            //   f77d0c               | mov                 al, 1
            //   8b4508               | push                0

        $sequence_11 = { 8b85e0feffff 83c001 8985e0feffff 81bde0feffff00010000 0f8d84000000 8b8de0feffff 0fb68c0df0feffff }
            // n = 7, score = 200
            //   8b85e0feffff         | dec                 eax
            //   83c001               | arpl                ax, dx
            //   8985e0feffff         | inc                 edx
            //   81bde0feffff00010000     | movzx    eax, byte ptr [edx + esi]
            //   0f8d84000000         | inc                 esp
            //   8b8de0feffff         | add                 eax, eax
            //   0fb68c0df0feffff     | inc                 esp

        $sequence_12 = { 44880a 410fb610 4103d1 81e2ff000080 7d0a }
            // n = 5, score = 200
            //   44880a               | lea                 ecx, [0xe9ee]
            //   410fb610             | jmp                 0xb
            //   4103d1               | xor                 ecx, ecx
            //   81e2ff000080         | dec                 eax
            //   7d0a                 | add                 esp, 0x38

        $sequence_13 = { 8a85effeffff 888415f0feffff 0fb64df8 0fb6940df0feffff }
            // n = 4, score = 200
            //   8a85effeffff         | movzx               ecx, byte ptr [eax]
            //   888415f0feffff       | dec                 eax
            //   0fb64df8             | add                 edx, eax
            //   0fb6940df0feffff     | inc                 ecx

        $sequence_14 = { 81c900ffffff 41 898de8feffff 8b85e0feffff 8a8c05f0feffff 888deffeffff 0fb695e8feffff }
            // n = 7, score = 200
            //   81c900ffffff         | dec                 eax
            //   41                   | inc                 ecx
            //   898de8feffff         | or                  eax, 0xffffff00
            //   8b85e0feffff         | inc                 ecx
            //   8a8c05f0feffff       | inc                 eax
            //   888deffeffff         | inc                 ecx
            //   0fb695e8feffff       | movzx               eax, al

        $sequence_15 = { 8d1492 03d2 2bc2 4863d0 420fb60432 4403c0 }
            // n = 6, score = 200
            //   8d1492               | ret                 
            //   03d2                 | inc                 esp
            //   2bc2                 | mov                 esi, eax
            //   4863d0               | jne                 0xf9
            //   420fb60432           | dec                 eax
            //   4403c0               | lea                 ecx, [0x5920]

        $sequence_16 = { 4863d0 420fb60432 4403c0 4403c6 4181e0ff000080 7d0d 41ffc8 }
            // n = 7, score = 200
            //   4863d0               | xor                 edx, edx
            //   420fb60432           | inc                 ecx
            //   4403c0               | mov                 eax, 0x800
            //   4403c6               | dec                 eax
            //   4181e0ff000080       | test                eax, eax
            //   7d0d                 | je                  0x1af
            //   41ffc8               | dec                 eax

        $sequence_17 = { ebd0 c785e8feffff00000000 c785e0feffff00000000 eb0f 8b85e0feffff 83c001 }
            // n = 6, score = 200
            //   ebd0                 | add                 edx, eax
            //   c785e8feffff00000000     | movzx    eax, byte ptr [edx]
            //   c785e0feffff00000000     | inc    ecx
            //   eb0f                 | mov                 byte ptr [eax], al
            //   8b85e0feffff         | dec                 eax
            //   83c001               | lea                 edx, [esp]

        $sequence_18 = { 450fb608 4803d0 0fb602 418800 }
            // n = 4, score = 200
            //   450fb608             | inc                 esp
            //   4803d0               | mov                 byte ptr [edx], cl
            //   0fb602               | inc                 ecx
            //   418800               | movzx               edx, byte ptr [eax]

        $sequence_19 = { 7d0d 41ffc8 4181c800ffffff 41ffc0 410fb6c0 488d1424 }
            // n = 6, score = 200
            //   7d0d                 | lea                 edx, [ebp + 0x620]
            //   41ffc8               | dec                 ecx
            //   4181c800ffffff       | mov                 ecx, dword ptr [esp + ecx]
            //   41ffc0               | mov                 dword ptr [esp + 0x48], ebx
            //   410fb6c0             | jne                 0xb
            //   488d1424             | dec                 eax

        $sequence_20 = { e9???????? c785dcfeffff00000000 eb0f 8b8ddcfeffff 83c101 }
            // n = 5, score = 200
            //   e9????????           |                     
            //   c785dcfeffff00000000     | add    eax, esi
            //   eb0f                 | inc                 ebp
            //   8b8ddcfeffff         | movzx               ecx, byte ptr [eax]
            //   83c101               | dec                 eax

        $sequence_21 = { 48 0d00ffffff 40 8945f8 8b4df8 0fb6940df0feffff }
            // n = 6, score = 200
            //   48                   | push                0x50
            //   0d00ffffff           | push                0x104
            //   40                   | push                0x104
            //   8945f8               | mov                 edi, eax
            //   8b4df8               | push                0
            //   0fb6940df0feffff     | push                0x104

        $sequence_22 = { ffc0 488d5201 3d00010000 7cf1 448bc1 448bc9 }
            // n = 6, score = 200
            //   ffc0                 | mov                 ecx, eax
            //   488d5201             | dec                 eax
            //   3d00010000           | lea                 edx, [0x58e1]
            //   7cf1                 | movzx               eax, byte ptr [edx]
            //   448bc1               | mov                 byte ptr [ebx - 1], al
            //   448bc9               | inc                 eax

        $sequence_23 = { 8b4508 0fb61410 03ca 81e1ff000080 }
            // n = 4, score = 200
            //   8b4508               | push                0
            //   0fb61410             | push                0
            //   03ca                 | push                0
            //   81e1ff000080         | push                0

        $sequence_24 = { 0fb602 8843ff 408832 4181f900010000 7c9a 488bdd 85ed }
            // n = 7, score = 200
            //   0fb602               | dec                 eax
            //   8843ff               | lea                 ecx, [0xa875]
            //   408832               | dec                 eax
            //   4181f900010000       | mov                 ecx, dword ptr [ecx + eax*8]
            //   7c9a                 | dec                 esp
            //   488bdd               | lea                 ecx, [esp + 0x4c]
            //   85ed                 | dec                 eax

        $sequence_25 = { 488d1424 4c03c0 410fb6c2 450fb608 4803d0 }
            // n = 5, score = 200
            //   488d1424             | inc                 ecx
            //   4c03c0               | add                 edx, ecx
            //   410fb6c2             | and                 edx, 0x800000ff
            //   450fb608             | jge                 0x19
            //   4803d0               | lea                 edx, [edx + edx*4]

        $sequence_26 = { 448bf0 0f85f3000000 488d0d20590000 33d2 41b800080000 ff15???????? 488bd8 }
            // n = 7, score = 100
            //   448bf0               | lea                 ebx, [0xa4e7]
            //   0f85f3000000         | dec                 eax
            //   488d0d20590000       | lea                 edi, [0xa4e0]
            //   33d2                 | jmp                 0x17
            //   41b800080000         | inc                 esp
            //   ff15????????         |                     
            //   488bd8               | mov                 esi, eax

        $sequence_27 = { 668986be010000 c74668885a4100 6a0d e8???????? 59 }
            // n = 5, score = 100
            //   668986be010000       | push                0x104
            //   c74668885a4100       | mov                 edi, eax
            //   6a0d                 | push                0
            //   e8????????           |                     
            //   59                   | push                edi

        $sequence_28 = { 743c 8b75e0 8bc6 c1f805 83e61f c1e606 03348520b72300 }
            // n = 7, score = 100
            //   743c                 | push                0x64
            //   8b75e0               | push                edx
            //   8bc6                 | push                eax
            //   c1f805               | add                 esp, 4
            //   83e61f               | push                0
            //   c1e606               | push                0x64
            //   03348520b72300       | push                edx

        $sequence_29 = { 488b442450 488d0d75a80000 488b0cc1 4c8d4c244c 488d9520060000 498b0c0c 895c2448 }
            // n = 7, score = 100
            //   488b442450           | dec                 eax
            //   488d0d75a80000       | mov                 dword ptr [eax], ecx
            //   488b0cc1             | mov                 dword ptr [eax + 8], ecx
            //   4c8d4c244c           | inc                 esp
            //   488d9520060000       | mov                 ebp, eax
            //   498b0c0c             | test                eax, eax
            //   895c2448             | je                  0x151

        $sequence_30 = { c3 48895c2408 57 4883ec20 488d1de7a40000 488d3de0a40000 eb0e }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   48895c2408           | dec                 eax
            //   57                   | mov                 dword ptr [esp + 8], ebx
            //   4883ec20             | push                edi
            //   488d1de7a40000       | dec                 eax
            //   488d3de0a40000       | sub                 esp, 0x20
            //   eb0e                 | dec                 eax

        $sequence_31 = { 8810 33ff 8d5001 8b048d606d4100 }
            // n = 4, score = 100
            //   8810                 | push                0
            //   33ff                 | push                edi
            //   8d5001               | push                edi
            //   8b048d606d4100       | push                8

        $sequence_32 = { 59 8b7508 8d34f570a02300 391e 7404 8bc7 eb6e }
            // n = 7, score = 100
            //   59                   | mov                 dword ptr [ebp - 0x118], 0
            //   8b7508               | mov                 dword ptr [ebp - 0x120], 0
            //   8d34f570a02300       | jmp                 0x25
            //   391e                 | mov                 eax, dword ptr [ebp - 0x120]
            //   7404                 | add                 eax, 1
            //   8bc7                 | mov                 eax, dword ptr [ebp - 0x120]
            //   eb6e                 | add                 eax, 1

        $sequence_33 = { 56 56 56 e8???????? 83c414 8b45fc ff34c51ca92300 }
            // n = 7, score = 100
            //   56                   | push                eax
            //   56                   | add                 esp, 4
            //   56                   | push                0
            //   e8????????           |                     
            //   83c414               | push                0x64
            //   8b45fc               | push                edx
            //   ff34c51ca92300       | push                eax

        $sequence_34 = { 7509 488d0deee90000 eb02 33c9 e8???????? 4883c438 c3 }
            // n = 7, score = 100
            //   7509                 | dec                 eax
            //   488d0deee90000       | mov                 ecx, dword ptr [esp + 0x50]
            //   eb02                 | dec                 eax
            //   33c9                 | and                 dword ptr [esp + 0x20], 0
            //   e8????????           |                     
            //   4883c438             | dec                 eax
            //   c3                   | lea                 eax, [0xab2f]

        $sequence_35 = { 8d0c8d20b72300 8901 8305????????20 8d9000080000 }
            // n = 4, score = 100
            //   8d0c8d20b72300       | mov                 ecx, dword ptr [ebp - 0x124]
            //   8901                 | add                 ecx, 1
            //   8305????????20       |                     
            //   8d9000080000         | jmp                 0xffffffd2

        $sequence_36 = { 7456 8b4de0 8d0c8d20b72300 8901 }
            // n = 4, score = 100
            //   7456                 | mov                 dword ptr [ebp - 0x120], eax
            //   8b4de0               | cmp                 dword ptr [ebp - 0x120], 0x100
            //   8d0c8d20b72300       | jge                 0x9d
            //   8901                 | mov                 al, byte ptr [ebp - 0x111]

        $sequence_37 = { 8965ec 6aff 6a00 8d4520 c741140f000000 c7411000000000 50 }
            // n = 7, score = 100
            //   8965ec               | dec                 eax
            //   6aff                 | or                  eax, 0xffffff00
            //   6a00                 | inc                 eax
            //   8d4520               | mov                 dword ptr [ebp - 8], eax
            //   c741140f000000       | mov                 ecx, dword ptr [ebp - 8]
            //   c7411000000000       | movzx               edx, byte ptr [ebp + ecx - 0x110]
            //   50                   | or                  ecx, 0xffffff00

        $sequence_38 = { 8a8c181d010000 8888b0a52300 40 ebe6 }
            // n = 4, score = 100
            //   8a8c181d010000       | mov                 ecx, dword ptr [ebp - 0x120]
            //   8888b0a52300         | movzx               ecx, byte ptr [ebp + ecx - 0x110]
            //   40                   | mov                 dword ptr [ebp - 0x124], 0
            //   ebe6                 | jmp                 0x11

        $sequence_39 = { 3b1cfd18a92300 7409 47 897dfc 83ff17 72ee }
            // n = 6, score = 100
            //   3b1cfd18a92300       | add                 esp, 4
            //   7409                 | push                0
            //   47                   | push                0x64
            //   897dfc               | push                edx
            //   83ff17               | add                 esp, 4
            //   72ee                 | push                0

        $sequence_40 = { 4c8d157da80000 33d2 4d8bc2 448d4a08 }
            // n = 4, score = 100
            //   4c8d157da80000       | je                  0x2e2
            //   33d2                 | xor                 ebx, ebx
            //   4d8bc2               | inc                 ecx
            //   448d4a08             | mov                 eax, 0x94

        $sequence_41 = { c785d4feffffffff1f00 8b4508 50 6a00 8b8dd4feffff 51 }
            // n = 6, score = 100
            //   c785d4feffffffff1f00     | push    eax
            //   8b4508               | mov                 eax, dword ptr [ebp - 0x120]
            //   50                   | add                 eax, 1
            //   6a00                 | mov                 dword ptr [ebp - 0x120], eax
            //   8b8dd4feffff         | cmp                 dword ptr [ebp - 0x120], 0x100
            //   51                   | jge                 0x9d

        $sequence_42 = { 8078035c 7505 8b75f0 03f0 83c005 83c205 }
            // n = 6, score = 100
            //   8078035c             | inc                 ecx
            //   7505                 | mov                 dword ptr [ebp - 0x118], ecx
            //   8b75f0               | mov                 eax, dword ptr [ebp - 0x120]
            //   03f0                 | mov                 cl, byte ptr [ebp + eax - 0x110]
            //   83c005               | mov                 byte ptr [ebp - 0x111], cl
            //   83c205               | movzx               edx, byte ptr [ebp - 0x118]

        $sequence_43 = { 41b894000000 488908 8b0d???????? 894808 0fb60d???????? }
            // n = 5, score = 100
            //   41b894000000         | dec                 eax
            //   488908               | mov                 ebx, eax
            //   8b0d????????         |                     
            //   894808               | mov                 ebx, dword ptr [esp + 0x44]
            //   0fb60d????????       |                     

        $sequence_44 = { ff15???????? 448be8 85c0 0f8449010000 488b4c2450 488364242000 488d052fab0000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   448be8               | dec                 eax
            //   85c0                 | lea                 eax, [0xa9df]
            //   0f8449010000         | dec                 edx
            //   488b4c2450           | mov                 ecx, dword ptr [eax + ebp*8]
            //   488364242000         | inc                 ecx
            //   488d052fab0000       | test                byte ptr [esp + ecx + 8], 0x80

        $sequence_45 = { 8b5c2444 e9???????? 488d05dfa90000 4a8b0ce8 41f6440c0880 0f84cb020000 33db }
            // n = 7, score = 100
            //   8b5c2444             | jne                 0xfc
            //   e9????????           |                     
            //   488d05dfa90000       | dec                 eax
            //   4a8b0ce8             | lea                 ecx, [0x5920]
            //   41f6440c0880         | xor                 edx, edx
            //   0f84cb020000         | inc                 ecx
            //   33db                 | mov                 eax, 0x800

    condition:
        7 of them and filesize < 262144
}