rule win_sliver_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sliver"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 488d3d59917900 4889c8 e8???????? ebe5 e8???????? eb80 }
            // n = 7, score = 100
            //   c3                   | dec                 eax
            //   488d3d59917900       | cmp                 edx, esi
            //   4889c8               | jne                 0x9a2
            //   e8????????           |                     
            //   ebe5                 | dec                 esp
            //   e8????????           |                     
            //   eb80                 | mov                 dword ptr [ecx + 0x30], ecx

        $sequence_1 = { ebd5 31c0 ebd1 31c0 ebcd 750e 4883bc249001000001 }
            // n = 7, score = 100
            //   ebd5                 | mov                 dword ptr [ecx + 0x40], ebp
            //   31c0                 | dec                 ecx
            //   ebd1                 | shl                 ecx, 4
            //   31c0                 | inc                 edi
            //   ebcd                 | mov                 dword ptr [edx + ecx], esp
            //   750e                 | inc                 ebx
            //   4883bc249001000001     | mov    byte ptr [edx + ecx + 4], 0

        $sequence_2 = { 7404 488b4008 0f57c0 0f11842488000000 4889842488000000 488b442458 4889842490000000 }
            // n = 7, score = 100
            //   7404                 | dec                 eax
            //   488b4008             | mov                 dword ptr [esp], ecx
            //   0f57c0               | dec                 eax
            //   0f11842488000000     | lea                 ecx, [esp + 0x28]
            //   4889842488000000     | dec                 eax
            //   488b442458           | mov                 dword ptr [esp + 8], ecx
            //   4889842490000000     | dec                 eax

        $sequence_3 = { eb8f 488b4c2450 488b542448 e9???????? 0fb67310 488d3ddb9c7700 0fb6343e }
            // n = 7, score = 100
            //   eb8f                 | mov                 eax, dword ptr [eax]
            //   488b4c2450           | dec                 eax
            //   488b542448           | mov                 ecx, dword ptr [eax]
            //   e9????????           |                     
            //   0fb67310             | jbe                 0xe1d
            //   488d3ddb9c7700       | dec                 eax
            //   0fb6343e             | sub                 esp, 0x20

        $sequence_4 = { ebd4 4889442410 90 488d05bf553e00 48890424 e8???????? 488b7c2408 }
            // n = 7, score = 100
            //   ebd4                 | dec                 eax
            //   4889442410           | mov                 dword ptr [esp + 0x90], ebx
            //   90                   | dec                 eax
            //   488d05bf553e00       | mov                 dword ptr [esp + 0x98], edx
            //   48890424             | xorps               xmm0, xmm0
            //   e8????????           |                     
            //   488b7c2408           | movups              xmmword ptr [esp + 0xa0], xmm0

        $sequence_5 = { ebea 90 b801000000 488d0d17948600 8701 488b05???????? 48890424 }
            // n = 7, score = 100
            //   ebea                 | mov                 dword ptr [esp], ecx
            //   90                   | mov                 byte ptr [esp + 8], al
            //   b801000000           | jge                 0x8a5
            //   488d0d17948600       | nop                 
            //   8701                 | dec                 eax
            //   488b05????????       |                     
            //   48890424             | mov                 eax, dword ptr [esp + 0xa8]

        $sequence_6 = { ebae 48894c2458 48895c2448 4889442440 488d050b972300 48890424 4c89442408 }
            // n = 7, score = 100
            //   ebae                 | sub                 esp, 0x30
            //   48894c2458           | dec                 eax
            //   48895c2448           | mov                 dword ptr [esp + 0x28], ebp
            //   4889442440           | dec                 eax
            //   488d050b972300       | lea                 ebp, [esp + 0x28]
            //   48890424             | nop                 
            //   4c89442408           | dec                 eax

        $sequence_7 = { ebd1 90 488d05f9140d00 48890424 e8???????? 488b7c2408 48c747084a000000 }
            // n = 7, score = 100
            //   ebd1                 | dec                 eax
            //   90                   | lea                 eax, [0xaba16]
            //   488d05f9140d00       | ja                  0xd5c
            //   48890424             | dec                 ebp
            //   e8????????           |                     
            //   488b7c2408           | lea                 ebx, [edx + 1]
            //   48c747084a000000     | dec                 esp

        $sequence_8 = { eb94 4883f80c 750d 488b8c2468010000 488b01 eb81 90 }
            // n = 7, score = 100
            //   eb94                 | lea                 eax, [0x357e0a]
            //   4883f80c             | jbe                 0x14a7
            //   750d                 | dec                 eax
            //   488b8c2468010000     | sub                 esp, 0x20
            //   488b01               | dec                 eax
            //   eb81                 | mov                 dword ptr [esp + 0x18], ebp
            //   90                   | dec                 eax

        $sequence_9 = { e9???????? 65488b0c2528000000 488b8900000000 483b6110 0f86ca000000 4883ec50 48896c2448 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   65488b0c2528000000     | dec    eax
            //   488b8900000000       | lea                 ecx, [0x26bbfa]
            //   483b6110             | dec                 eax
            //   0f86ca000000         | mov                 edx, dword ptr [esp + 0x168]
            //   4883ec50             | dec                 eax
            //   48896c2448           | mov                 dword ptr [edx], ecx

    condition:
        7 of them and filesize < 18211840
}