rule win_snowflake_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.snowflake_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snowflake_stealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7320 8d2c39 896c241c e8???????? 83c40c 89442414 85c0 }
            // n = 7, score = 100
            //   ff7320               | push                dword ptr [ebx + 0x20]
            //   8d2c39               | lea                 ebp, [ecx + edi]
            //   896c241c             | mov                 dword ptr [esp + 0x1c], ebp
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   85c0                 | test                eax, eax

        $sequence_1 = { f3a5 8d74243c 89c7 0fb70c24 66894844 66895046 89f1 }
            // n = 7, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8d74243c             | lea                 esi, [esp + 0x3c]
            //   89c7                 | mov                 edi, eax
            //   0fb70c24             | movzx               ecx, word ptr [esp]
            //   66894844             | mov                 word ptr [eax + 0x44], cx
            //   66895046             | mov                 word ptr [eax + 0x46], dx
            //   89f1                 | mov                 ecx, esi

        $sequence_2 = { e9???????? 8b0d???????? 898424d8000000 89842434010000 8d0532db5b00 899424dc000000 89942438010000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b0d????????         |                     
            //   898424d8000000       | mov                 dword ptr [esp + 0xd8], eax
            //   89842434010000       | mov                 dword ptr [esp + 0x134], eax
            //   8d0532db5b00         | lea                 eax, [0x5bdb32]
            //   899424dc000000       | mov                 dword ptr [esp + 0xdc], edx
            //   89942438010000       | mov                 dword ptr [esp + 0x138], edx

        $sequence_3 = { f20f114808 f20f1100 83c010 8906 ff4608 83c410 5e }
            // n = 7, score = 100
            //   f20f114808           | movsd               qword ptr [eax + 8], xmm1
            //   f20f1100             | movsd               qword ptr [eax], xmm0
            //   83c010               | add                 eax, 0x10
            //   8906                 | mov                 dword ptr [esi], eax
            //   ff4608               | inc                 dword ptr [esi + 8]
            //   83c410               | add                 esp, 0x10
            //   5e                   | pop                 esi

        $sequence_4 = { ffb42480000000 6a38 ff742448 55 e8???????? 8b5c2434 8d4524 }
            // n = 7, score = 100
            //   ffb42480000000       | push                dword ptr [esp + 0x80]
            //   6a38                 | push                0x38
            //   ff742448             | push                dword ptr [esp + 0x48]
            //   55                   | push                ebp
            //   e8????????           |                     
            //   8b5c2434             | mov                 ebx, dword ptr [esp + 0x34]
            //   8d4524               | lea                 eax, [ebp + 0x24]

        $sequence_5 = { ff750c ff30 ff15???????? c9 c3 53 56 }
            // n = 7, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff30                 | push                dword ptr [eax]
            //   ff15????????         |                     
            //   c9                   | leave               
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_6 = { eb11 89c1 ba05010000 68???????? e8???????? 58 0f0b }
            // n = 7, score = 100
            //   eb11                 | jmp                 0x13
            //   89c1                 | mov                 ecx, eax
            //   ba05010000           | mov                 edx, 0x105
            //   68????????           |                     
            //   e8????????           |                     
            //   58                   | pop                 eax
            //   0f0b                 | ud2                 

        $sequence_7 = { ff4608 ba???????? 89f1 6a03 e8???????? 59 89c2 }
            // n = 7, score = 100
            //   ff4608               | inc                 dword ptr [esi + 8]
            //   ba????????           |                     
            //   89f1                 | mov                 ecx, esi
            //   6a03                 | push                3
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   89c2                 | mov                 edx, eax

        $sequence_8 = { f20f1144242c e8???????? f20f5805???????? f20f104c242c 51 51 f20f5ec8 }
            // n = 7, score = 100
            //   f20f1144242c         | movsd               qword ptr [esp + 0x2c], xmm0
            //   e8????????           |                     
            //   f20f5805????????     |                     
            //   f20f104c242c         | movsd               xmm1, qword ptr [esp + 0x2c]
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   f20f5ec8             | divsd               xmm1, xmm0

        $sequence_9 = { ff4f3c 837e0801 7509 396e0c 7504 834f1cff 3906 }
            // n = 7, score = 100
            //   ff4f3c               | dec                 dword ptr [edi + 0x3c]
            //   837e0801             | cmp                 dword ptr [esi + 8], 1
            //   7509                 | jne                 0xb
            //   396e0c               | cmp                 dword ptr [esi + 0xc], ebp
            //   7504                 | jne                 6
            //   834f1cff             | or                  dword ptr [edi + 0x1c], 0xffffffff
            //   3906                 | cmp                 dword ptr [esi], eax

    condition:
        7 of them and filesize < 6196224
}