rule win_soul_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.soul."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.soul"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { d3e2 8515???????? 7405 e8???????? }
            // n = 4, score = 400
            //   d3e2                 | shl                 edx, cl
            //   8515????????         |                     
            //   7405                 | je                  7
            //   e8????????           |                     

        $sequence_1 = { 40 803800 75f8 c745fc00000000 90 56 ff15???????? }
            // n = 7, score = 400
            //   40                   | mov                 dword ptr [esp + 0x10], esi
            //   803800               | push                edi
            //   75f8                 | dec                 eax
            //   c745fc00000000       | sub                 esp, 0x30
            //   90                   | dec                 eax
            //   56                   | mov                 ebx, ecx
            //   ff15????????         |                     

        $sequence_2 = { 57 8bf8 be???????? 743a 8da42400000000 }
            // n = 5, score = 400
            //   57                   | dec                 eax
            //   8bf8                 | mov                 ebx, ecx
            //   be????????           |                     
            //   743a                 | dec                 eax
            //   8da42400000000       | test                ecx, ecx

        $sequence_3 = { ff25???????? 48895c2408 4889742410 57 4883ec30 }
            // n = 5, score = 400
            //   ff25????????         |                     
            //   48895c2408           | dec                 eax
            //   4889742410           | mov                 dword ptr [esp + 8], ebx
            //   57                   | dec                 eax
            //   4883ec30             | mov                 dword ptr [esp + 0x10], esi

        $sequence_4 = { 7cde c745fc00000000 8da42400000000 8b4df8 51 57 }
            // n = 6, score = 400
            //   7cde                 | sub                 esp, 0x30
            //   c745fc00000000       | inc                 esp
            //   8da42400000000       | sub                 ebx, edx
            //   8b4df8               | inc                 ecx
            //   51                   | cmp                 ebx, 0xf
            //   57                   | jae                 0x24

        $sequence_5 = { 741f 8da42400000000 8b03 57 50 }
            // n = 5, score = 400
            //   741f                 | push                edi
            //   8da42400000000       | dec                 eax
            //   8b03                 | sub                 esp, 0x30
            //   57                   | dec                 eax
            //   50                   | mov                 ebx, ecx

        $sequence_6 = { 85f6 0f84a4000000 803f00 8bc7 }
            // n = 4, score = 400
            //   85f6                 | push                edi
            //   0f84a4000000         | dec                 eax
            //   803f00               | mov                 dword ptr [esp + 8], ebx
            //   8bc7                 | dec                 eax

        $sequence_7 = { 85f6 7506 837dfc04 7cda }
            // n = 4, score = 400
            //   85f6                 | dec                 eax
            //   7506                 | mov                 dword ptr [esp + 8], ebx
            //   837dfc04             | dec                 eax
            //   7cda                 | mov                 dword ptr [esp + 0x10], esi

        $sequence_8 = { 7409 90 fe08 40 803800 }
            // n = 5, score = 400
            //   7409                 | dec                 eax
            //   90                   | mov                 dword ptr [esp + 0x10], esi
            //   fe08                 | push                edi
            //   40                   | dec                 eax
            //   803800               | sub                 esp, 0x30

        $sequence_9 = { 83c404 33f6 897304 8b4304 }
            // n = 4, score = 400
            //   83c404               | dec                 eax
            //   33f6                 | mov                 dword ptr [esp + 8], ebx
            //   897304               | dec                 eax
            //   8b4304               | mov                 dword ptr [esp + 0x10], esi

        $sequence_10 = { eb22 e8???????? 488b4c2420 ffd0 90 48837c245008 }
            // n = 6, score = 200
            //   eb22                 | mov                 eax, dword ptr [ebx]
            //   e8????????           |                     
            //   488b4c2420           | push                edi
            //   ffd0                 | push                eax
            //   90                   | push                ebx
            //   48837c245008         | push                esi

        $sequence_11 = { c744243a66003600 66448974243e 488d1d4ad10100 488bc3 488d7c2448 482bfb 0fb710 }
            // n = 7, score = 200
            //   c744243a66003600     | cmp                 byte ptr [eax], 0
            //   66448974243e         | jne                 0xfffffffe
            //   488d1d4ad10100       | cmp                 byte ptr [esi], 0
            //   488bc3               | mov                 eax, esi
            //   488d7c2448           | je                  0x16
            //   482bfb               | je                  0x3c
            //   0fb710               | lea                 esp, [esp]

        $sequence_12 = { ffc7 4883c202 413bf8 72db 8bce 85f6 743c }
            // n = 7, score = 200
            //   ffc7                 | push                edi
            //   4883c202             | dec                 eax
            //   413bf8               | mov                 dword ptr [esp + 8], ebx
            //   72db                 | dec                 eax
            //   8bce                 | mov                 dword ptr [esp + 0x10], esi
            //   85f6                 | push                edi
            //   743c                 | dec                 eax

        $sequence_13 = { 7507 c743089a020000 85c0 0f84be010000 83f802 0f84b5010000 83f801 }
            // n = 7, score = 200
            //   7507                 | sub                 esp, 0x30
            //   c743089a020000       | dec                 eax
            //   85c0                 | mov                 ebx, ecx
            //   0f84be010000         | dec                 eax
            //   83f802               | mov                 dword ptr [esp + 8], ebx
            //   0f84b5010000         | dec                 eax
            //   83f801               | mov                 dword ptr [esp + 0x10], esi

        $sequence_14 = { 741a 488d05f9ef0000 483bf8 740e 833f00 }
            // n = 5, score = 200
            //   741a                 | push                edi
            //   488d05f9ef0000       | mov                 edi, eax
            //   483bf8               | je                  0x3c
            //   740e                 | lea                 esp, [esp]
            //   833f00               | cmp                 dword ptr [esi + 4], 0

        $sequence_15 = { 4c8bf1 b801000000 85ff 7404 8932 eb06 8bf8 }
            // n = 7, score = 200
            //   4c8bf1               | cmp                 eax, 2
            //   b801000000           | je                  0x1cd
            //   85ff                 | cmp                 eax, 1
            //   7404                 | inc                 ecx
            //   8932                 | mov                 dword ptr [esi + 0x20], eax
            //   eb06                 | inc                 ebp
            //   8bf8                 | mov                 ebp, edi

        $sequence_16 = { c745c047006c00 c745c662006100 c745ca6c005c00 668945ec c745ce43006100 c745d468006500 }
            // n = 6, score = 200
            //   c745c047006c00       | push                edi
            //   c745c662006100       | mov                 edi, eax
            //   c745ca6c005c00       | lea                 ebx, [ebx]
            //   668945ec             | dec                 byte ptr [eax]
            //   c745ce43006100       | inc                 eax
            //   c745d468006500       | cmp                 byte ptr [eax], 0

        $sequence_17 = { 442bda 4183fb0f 731e 0fb606 418bcb 4883c602 }
            // n = 6, score = 200
            //   442bda               | inc                 edi
            //   4183fb0f             | dec                 eax
            //   731e                 | add                 edx, 2
            //   0fb606               | inc                 ecx
            //   418bcb               | cmp                 edi, eax
            //   4883c602             | jb                  0xffffffe4

        $sequence_18 = { e8???????? 41894620 458bef 418bff 41c74608373f0000 eb05 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   41894620             | push                edi
            //   458bef               | dec                 eax
            //   418bff               | sub                 esp, 0x30
            //   41c74608373f0000     | dec                 eax
            //   eb05                 | mov                 ebx, ecx

        $sequence_19 = { 488b4593 89442448 8bc8 e8???????? 488bf0 33c0 8945c7 }
            // n = 7, score = 200
            //   488b4593             | lea                 esp, [esp]
            //   89442448             | mov                 ecx, dword ptr [ebp - 8]
            //   8bc8                 | push                ecx
            //   e8????????           |                     
            //   488bf0               | push                edi
            //   33c0                 | dec                 byte ptr [eax]
            //   8945c7               | inc                 eax

        $sequence_20 = { 4883eb02 4983c9ff ebae 488d45ef 4c8b4507 4983f808 490f43c4 }
            // n = 7, score = 200
            //   4883eb02             | mov                 ecx, esi
            //   4983c9ff             | test                esi, esi
            //   ebae                 | je                  0x4b
            //   488d45ef             | jne                 9
            //   4c8b4507             | mov                 dword ptr [ebx + 8], 0x29a
            //   4983f808             | test                eax, eax
            //   490f43c4             | je                  0x1cd

        $sequence_21 = { eb2e 4c8b542418 33ed 0f1f840000000000 420fb60411 48ffc1 }
            // n = 6, score = 200
            //   eb2e                 | jne                 8
            //   4c8b542418           | cmp                 dword ptr [ebp - 4], 4
            //   33ed                 | jl                  0xffffffe0
            //   0f1f840000000000     | mov                 dword ptr [ebp - 4], 0
            //   420fb60411           | jl                  0xffffffe0
            //   48ffc1               | mov                 dword ptr [ebp - 4], 0

        $sequence_22 = { 488d1dc7850000 488d3de0850000 eb0e 488b03 4885c0 7402 }
            // n = 6, score = 200
            //   488d1dc7850000       | add                 esp, 4
            //   488d3de0850000       | xor                 esi, esi
            //   eb0e                 | mov                 dword ptr [ebx + 4], esi
            //   488b03               | mov                 eax, dword ptr [ebx + 4]
            //   4885c0               | je                  0x21
            //   7402                 | lea                 esp, [esp]

    condition:
        7 of them and filesize < 1400832
}