rule win_starsypound_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.starsypound."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.starsypound"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8dbc2458010000 83c9ff 33c0 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   8dbc2458010000       | lea                 edi, [esp + 0x158]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 68???????? 52 e8???????? 83c420 85c0 7444 8b5304 }
            // n = 7, score = 100
            //   68????????           |                     
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   85c0                 | test                eax, eax
            //   7444                 | je                  0x46
            //   8b5304               | mov                 edx, dword ptr [ebx + 4]

        $sequence_2 = { 53 56 57 6a18 e8???????? 8bb42424040000 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a18                 | push                0x18
            //   e8????????           |                     
            //   8bb42424040000       | mov                 esi, dword ptr [esp + 0x424]

        $sequence_3 = { 8d4c2428 68???????? 51 e8???????? 56 8d542434 }
            // n = 6, score = 100
            //   8d4c2428             | lea                 ecx, [esp + 0x28]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   56                   | push                esi
            //   8d542434             | lea                 edx, [esp + 0x34]

        $sequence_4 = { 8bfd 8d44240c f3a5 8b5500 8b3d???????? 6a00 }
            // n = 6, score = 100
            //   8bfd                 | mov                 edi, ebp
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8b5500               | mov                 edx, dword ptr [ebp]
            //   8b3d????????         |                     
            //   6a00                 | push                0

        $sequence_5 = { 885c3438 c744241804010000 ff15???????? 8dbc2458010000 83c9ff 33c0 }
            // n = 6, score = 100
            //   885c3438             | mov                 byte ptr [esp + esi + 0x38], bl
            //   c744241804010000     | mov                 dword ptr [esp + 0x18], 0x104
            //   ff15????????         |                     
            //   8dbc2458010000       | lea                 edi, [esp + 0x158]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 50 8d4c2424 56 51 52 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   56                   | push                esi
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_7 = { f3a4 885c0444 bf???????? 83c9ff 33c0 33f6 }
            // n = 6, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   885c0444             | mov                 byte ptr [esp + eax + 0x44], bl
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   33f6                 | xor                 esi, esi

        $sequence_8 = { 83c40c 85c0 7e2b eb08 }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   7e2b                 | jle                 0x2d
            //   eb08                 | jmp                 0xa

        $sequence_9 = { e8???????? 68c0270900 ff15???????? e8???????? 5f }
            // n = 5, score = 100
            //   e8????????           |                     
            //   68c0270900           | push                0x927c0
            //   ff15????????         |                     
            //   e8????????           |                     
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 40960
}