rule win_stealbit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.stealbit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stealbit"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 58 6a74 668945ea 58 6a65 668945ec 58 }
            // n = 7, score = 300
            //   58                   | pop                 eax
            //   6a74                 | push                0x74
            //   668945ea             | mov                 word ptr [ebp - 0x16], ax
            //   58                   | pop                 eax
            //   6a65                 | push                0x65
            //   668945ec             | mov                 word ptr [ebp - 0x14], ax
            //   58                   | pop                 eax

        $sequence_1 = { e8???????? 8bcf 894508 e8???????? 8b4d08 33c8 741f }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8bcf                 | mov                 ecx, edi
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   e8????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   33c8                 | xor                 ecx, eax
            //   741f                 | je                  0x21

        $sequence_2 = { 884105 e8???????? 6a03 6a4f 884106 e8???????? }
            // n = 6, score = 300
            //   884105               | mov                 byte ptr [ecx + 5], al
            //   e8????????           |                     
            //   6a03                 | push                3
            //   6a4f                 | push                0x4f
            //   884106               | mov                 byte ptr [ecx + 6], al
            //   e8????????           |                     

        $sequence_3 = { e8???????? 40 50 8b54240c }
            // n = 4, score = 300
            //   e8????????           |                     
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]

        $sequence_4 = { 42 83fa46 72ed 8bc6 5e c3 55 }
            // n = 7, score = 300
            //   42                   | inc                 edx
            //   83fa46               | cmp                 edx, 0x46
            //   72ed                 | jb                  0xffffffef
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_5 = { 6a20 5e 56 884106 e8???????? 6a04 }
            // n = 6, score = 300
            //   6a20                 | push                0x20
            //   5e                   | pop                 esi
            //   56                   | push                esi
            //   884106               | mov                 byte ptr [ecx + 6], al
            //   e8????????           |                     
            //   6a04                 | push                4

        $sequence_6 = { 59 85c0 0f840d030000 57 8d9574feffff 8bce }
            // n = 6, score = 300
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   0f840d030000         | je                  0x313
            //   57                   | push                edi
            //   8d9574feffff         | lea                 edx, [ebp - 0x18c]
            //   8bce                 | mov                 ecx, esi

        $sequence_7 = { 58 6a6f 6689856cffffff 58 6a67 6689856effffff 66898d68ffffff }
            // n = 7, score = 300
            //   58                   | pop                 eax
            //   6a6f                 | push                0x6f
            //   6689856cffffff       | mov                 word ptr [ebp - 0x94], ax
            //   58                   | pop                 eax
            //   6a67                 | push                0x67
            //   6689856effffff       | mov                 word ptr [ebp - 0x92], ax
            //   66898d68ffffff       | mov                 word ptr [ebp - 0x98], cx

        $sequence_8 = { e8???????? 6689421a 0fb705???????? 50 e8???????? 6689421c 0fb705???????? }
            // n = 7, score = 300
            //   e8????????           |                     
            //   6689421a             | mov                 word ptr [edx + 0x1a], ax
            //   0fb705????????       |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   6689421c             | mov                 word ptr [edx + 0x1c], ax
            //   0fb705????????       |                     

        $sequence_9 = { e8???????? 33c0 59 40 eb07 e8???????? 33c0 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   59                   | pop                 ecx
            //   40                   | inc                 eax
            //   eb07                 | jmp                 9
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 131072
}