rule win_stealhook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.stealhook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stealhook"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4983c002 4863c8 493bc9 72d8 488d3599d60700 418bc5 4983fa07 }
            // n = 7, score = 100
            //   4983c002             | lea                 ecx, [edi + 1]
            //   4863c8               | dec                 eax
            //   493bc9               | mov                 eax, 0xffffffff
            //   72d8                 | dec                 eax
            //   488d3599d60700       | lea                 ecx, [esp + 0x30]
            //   418bc5               | nop                 
            //   4983fa07             | dec                 eax

        $sequence_1 = { 488bc6 4983fa07 490f47c3 6644390401 7410 ffc2 4883c102 }
            // n = 7, score = 100
            //   488bc6               | mov                 eax, dword ptr [ebx]
            //   4983fa07             | dec                 eax
            //   490f47c3             | arpl                word ptr [eax + 4], cx
            //   6644390401           | dec                 eax
            //   7410                 | add                 ecx, ebx
            //   ffc2                 | or                  esi, dword ptr [ecx + 0x10]
            //   4883c102             | mov                 eax, 4

        $sequence_2 = { 4c8b642440 488b75cf 498b7d28 4885ff 7e0a 483bfe 7605 }
            // n = 7, score = 100
            //   4c8b642440           | sub                 eax, dword ptr [esp + 0x58]
            //   488b75cf             | dec                 eax
            //   498b7d28             | cmp                 eax, 0xa
            //   4885ff               | jae                 0x151
            //   7e0a                 | dec                 eax
            //   483bfe               | lea                 ecx, [0x39b54]
            //   7605                 | dec                 ecx

        $sequence_3 = { f30f7f4590 c6458000 0f57c0 0f11442420 4889742430 4889742438 4c8d7dc0 }
            // n = 7, score = 100
            //   f30f7f4590           | mov                 byte ptr [ebx + 8], 1
            //   c6458000             | inc                 sp
            //   0f57c0               | cmp                 dword ptr [ebx + 0xa], edi
            //   0f11442420           | jne                 0x841
            //   4889742430           | dec                 eax
            //   4889742438           | mov                 ecx, dword ptr [ebx]
            //   4c8d7dc0             | dec                 eax

        $sequence_4 = { 488b442478 49894550 49894558 49899d80000000 488b05???????? 49894574 49896d68 }
            // n = 7, score = 100
            //   488b442478           | ja                  0xa3
            //   49894550             | dec                 eax
            //   49894558             | mov                 ecx, dword ptr [ebx + 0x48]
            //   49899d80000000       | dec                 esp
            //   488b05????????       |                     
            //   49894574             | mov                 eax, esi
            //   49896d68             | xor                 edx, edx

        $sequence_5 = { 84c0 0f84e3020000 488d4d18 48837d300f 480f474d18 80397f 0f83cc020000 }
            // n = 7, score = 100
            //   84c0                 | dec                 eax
            //   0f84e3020000         | mov                 dword ptr [edi], ebx
            //   488d4d18             | inc                 eax
            //   48837d300f           | test                dh, 1
            //   480f474d18           | and                 dword ptr [ebx + 8], 0
            //   80397f               | dec                 eax
            //   0f83cc020000         | lea                 eax, [0x49e9b]

        $sequence_6 = { 488b8c2428010000 e8???????? 488b8c2428010000 e8???????? 488b942428030000 4883fa07 763b }
            // n = 7, score = 100
            //   488b8c2428010000     | mov                 dword ptr [ecx + 0xd8], edi
            //   e8????????           |                     
            //   488b8c2428010000     | dec                 eax
            //   e8????????           |                     
            //   488b942428030000     | mov                 dword ptr [ecx + 0xe0], edi
            //   4883fa07             | dec                 eax
            //   763b                 | mov                 dword ptr [ecx + 0xe8], edi

        $sequence_7 = { 488bd5 488bc7 48d1ea 482bc2 483be8 77e3 }
            // n = 6, score = 100
            //   488bd5               | mov                 dword ptr [esp + 0x298], ecx
            //   488bc7               | dec                 eax
            //   48d1ea               | mov                 eax, dword ptr [ecx]
            //   482bc2               | call                dword ptr [eax + 8]
            //   483be8               | nop                 
            //   77e3                 | dec                 eax

        $sequence_8 = { e8???????? 0f1038 0f117dc0 0f107010 0f1175d0 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   0f1038               | dec                 eax
            //   0f117dc0             | cmp                 esi, ebx
            //   0f107010             | jbe                 0x130
            //   0f1175d0             | dec                 eax

        $sequence_9 = { 450fb706 4885db 744c 488b4340 48833800 741f }
            // n = 6, score = 100
            //   450fb706             | dec                 eax
            //   4885db               | lea                 eax, [0x40d1c]
            //   744c                 | inc                 ecx
            //   488b4340             | mov                 ecx, 6
            //   48833800             | dec                 eax
            //   741f                 | lea                 eax, [0x3717c]

    condition:
        7 of them and filesize < 1129472
}