rule win_stresspaint_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.stresspaint."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stresspaint"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0103 014510 294514 83665800 }
            // n = 4, score = 100
            //   0103                 | add                 dword ptr [ebx], eax
            //   014510               | add                 dword ptr [ebp + 0x10], eax
            //   294514               | sub                 dword ptr [ebp + 0x14], eax
            //   83665800             | and                 dword ptr [esi + 0x58], 0

        $sequence_1 = { 8d54241c 52 6880000000 e8???????? }
            // n = 4, score = 100
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx
            //   6880000000           | push                0x80
            //   e8????????           |                     

        $sequence_2 = { 0106 83560400 837d1c00 7494 }
            // n = 4, score = 100
            //   0106                 | add                 dword ptr [esi], eax
            //   83560400             | adc                 dword ptr [esi + 4], 0
            //   837d1c00             | cmp                 dword ptr [ebp + 0x1c], 0
            //   7494                 | je                  0xffffff96

        $sequence_3 = { 0103 ebaa 8b442408 56 }
            // n = 4, score = 100
            //   0103                 | add                 dword ptr [ebx], eax
            //   ebaa                 | jmp                 0xffffffac
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   56                   | push                esi

        $sequence_4 = { 0107 115f04 3bcb 7508 }
            // n = 4, score = 100
            //   0107                 | add                 dword ptr [edi], eax
            //   115f04               | adc                 dword ptr [edi + 4], ebx
            //   3bcb                 | cmp                 ecx, ebx
            //   7508                 | jne                 0xa

        $sequence_5 = { 0108 8b8e44010000 114804 8b4f18 }
            // n = 4, score = 100
            //   0108                 | add                 dword ptr [eax], ecx
            //   8b8e44010000         | mov                 ecx, dword ptr [esi + 0x144]
            //   114804               | adc                 dword ptr [eax + 4], ecx
            //   8b4f18               | mov                 ecx, dword ptr [edi + 0x18]

        $sequence_6 = { 8d54241c 52 50 56 e8???????? 8b4c243c }
            // n = 6, score = 100
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b4c243c             | mov                 ecx, dword ptr [esp + 0x3c]

        $sequence_7 = { 8d54241c 52 51 55 }
            // n = 4, score = 100
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx
            //   51                   | push                ecx
            //   55                   | push                ebp

        $sequence_8 = { 8d54241c 52 56 50 e8???????? 83c40c }
            // n = 6, score = 100
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_9 = { 0107 83570400 85c9 7508 }
            // n = 4, score = 100
            //   0107                 | add                 dword ptr [edi], eax
            //   83570400             | adc                 dword ptr [edi + 4], 0
            //   85c9                 | test                ecx, ecx
            //   7508                 | jne                 0xa

        $sequence_10 = { 8d54241c 52 50 57 e8???????? 53 }
            // n = 6, score = 100
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_11 = { 010b 8945fc 8bc2 83530400 }
            // n = 4, score = 100
            //   010b                 | add                 dword ptr [ebx], ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8bc2                 | mov                 eax, edx
            //   83530400             | adc                 dword ptr [ebx + 4], 0

        $sequence_12 = { 8d54241c 52 8d8424e4000000 6800040000 }
            // n = 4, score = 100
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx
            //   8d8424e4000000       | lea                 eax, [esp + 0xe4]
            //   6800040000           | push                0x400

        $sequence_13 = { 0103 014510 294674 8b4674 }
            // n = 4, score = 100
            //   0103                 | add                 dword ptr [ebx], eax
            //   014510               | add                 dword ptr [ebp + 0x10], eax
            //   294674               | sub                 dword ptr [esi + 0x74], eax
            //   8b4674               | mov                 eax, dword ptr [esi + 0x74]

        $sequence_14 = { 8d54241c 51 8d442430 52 50 55 56 }
            // n = 7, score = 100
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   51                   | push                ecx
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   52                   | push                edx
            //   50                   | push                eax
            //   55                   | push                ebp
            //   56                   | push                esi

        $sequence_15 = { 8d54241c 52 56 ff5718 56 53 }
            // n = 6, score = 100
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx
            //   56                   | push                esi
            //   ff5718               | call                dword ptr [edi + 0x18]
            //   56                   | push                esi
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 1155072
}