rule win_strifewater_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.strifewater_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.strifewater_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 4154 4155 4156 4157 488dac24e0d4ffff b8202c0000 }
            // n = 7, score = 100
            //   57                   | dec                 eax
            //   4154                 | test                ebx, ebx
            //   4155                 | setne               al
            //   4156                 | dec                 eax
            //   4157                 | mov                 ebx, dword ptr [esp + 0x30]
            //   488dac24e0d4ffff     | dec                 eax
            //   b8202c0000           | add                 esp, 0x20

        $sequence_1 = { 48894108 48894110 488d05574d0400 488901 488bc1 c3 33c0 }
            // n = 7, score = 100
            //   48894108             | mov                 dl, 0x25
            //   48894110             | dec                 eax
            //   488d05574d0400       | lea                 ecx, [esp + 0x30]
            //   488901               | mov                 edx, 2
            //   488bc1               | dec                 eax
            //   c3                   | and                 dword ptr [edi + 0xb8], 0
            //   33c0                 | dec                 eax

        $sequence_2 = { 488d0d3c8f0600 e8???????? 48894610 e8???????? 488bf8 4885c0 7414 }
            // n = 7, score = 100
            //   488d0d3c8f0600       | mov                 ebp, edx
            //   e8????????           |                     
            //   48894610             | dec                 eax
            //   e8????????           |                     
            //   488bf8               | mov                 dword ptr [ebx], eax
            //   4885c0               | xor                 ecx, ecx
            //   7414                 | dec                 eax

        $sequence_3 = { 7510 e8???????? c70016000000 e8???????? 488d4318 498906 488b5c2450 }
            // n = 7, score = 100
            //   7510                 | sub                 esp, 0x20
            //   e8????????           |                     
            //   c70016000000         | dec                 eax
            //   e8????????           |                     
            //   488d4318             | lea                 eax, [0x46ec3]
            //   498906               | dec                 eax
            //   488b5c2450           | mov                 edi, ecx

        $sequence_4 = { 48894c2428 4889442420 4c8d8dc8010000 448bc6 488d154fff0800 488d8d900f0000 e8???????? }
            // n = 7, score = 100
            //   48894c2428           | dec                 eax
            //   4889442420           | mov                 dword ptr [ebx], ecx
            //   4c8d8dc8010000       | dec                 eax
            //   448bc6               | lea                 edx, [ebx + 8]
            //   488d154fff0800       | mov                 byte ptr [esp + 0x28], 1
            //   488d8d900f0000       | dec                 eax
            //   e8????????           |                     

        $sequence_5 = { 488bf0 4863cb c6040100 33c9 85db 7e3f 488bd0 }
            // n = 7, score = 100
            //   488bf0               | dec                 esp
            //   4863cb               | mov                 dword ptr [ebx + 0x18], ebp
            //   c6040100             | dec                 eax
            //   33c9                 | mov                 ecx, dword ptr [esp + 0x70]
            //   85db                 | dec                 esp
            //   7e3f                 | mov                 dword ptr [ebx + 0x18], ebp
            //   488bd0               | dec                 esp

        $sequence_6 = { 0338 85ff 0f8ee0010000 4863f7 488bce e8???????? 4c8bf0 }
            // n = 7, score = 100
            //   0338                 | dec                 eax
            //   85ff                 | mov                 eax, dword ptr [eax]
            //   0f8ee0010000         | dec                 eax
            //   4863f7               | lea                 edx, [ebp + 0x150]
            //   488bce               | dec                 eax
            //   e8????????           |                     
            //   4c8bf0               | lea                 ecx, [ebp + 0x190]

        $sequence_7 = { 488d05d8e3feff 4889442430 488d4c2420 e8???????? 4c396b08 74f0 488b5b08 }
            // n = 7, score = 100
            //   488d05d8e3feff       | dec                 ebp
            //   4889442430           | mov                 eax, ebp
            //   488d4c2420           | and                 eax, ecx
            //   e8????????           |                     
            //   4c396b08             | cmp                 eax, ecx
            //   74f0                 | je                  0x3b8
            //   488b5b08             | dec                 eax

        $sequence_8 = { 4053 4883ec20 488bd9 488bc2 488d0d0d890200 48890b 488d5308 }
            // n = 7, score = 100
            //   4053                 | dec                 ecx
            //   4883ec20             | mov                 ecx, edi
            //   488bd9               | dec                 ecx
            //   488bc2               | mov                 ecx, esi
            //   488d0d0d890200       | dec                 eax
            //   48890b               | lea                 edx, [ebp + 0x90]
            //   488d5308             | dec                 ecx

        $sequence_9 = { 90 be01000000 89b424b0000000 83630800 488d0d10400500 48890b }
            // n = 6, score = 100
            //   90                   | je                  0x3243
            //   be01000000           | dec                 eax
            //   89b424b0000000       | lea                 ecx, [0x797bc]
            //   83630800             | dec                 eax
            //   488d0d10400500       | lea                 ecx, [0x797a9]
            //   48890b               | inc                 eax

    condition:
        7 of them and filesize < 1552384
}