rule win_strongpity_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.strongpity."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.strongpity"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6aff ff771c 56 ff15???????? 837df800 7416 6a04 }
            // n = 7, score = 700
            //   6aff                 | push                -1
            //   ff771c               | push                dword ptr [edi + 0x1c]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7416                 | je                  0x18
            //   6a04                 | push                4

        $sequence_1 = { 53 56 ff15???????? 85c0 7427 53 }
            // n = 6, score = 700
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7427                 | je                  0x29
            //   53                   | push                ebx

        $sequence_2 = { eb0f 50 56 e8???????? 59 59 }
            // n = 6, score = 700
            //   eb0f                 | jmp                 0x11
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_3 = { 75f8 ff75d0 68???????? ff36 e8???????? 8b45d4 }
            // n = 6, score = 700
            //   75f8                 | jne                 0xfffffffa
            //   ff75d0               | push                dword ptr [ebp - 0x30]
            //   68????????           |                     
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]

        $sequence_4 = { 6a6f 668945d4 58 6a6e 5a 6a74 }
            // n = 6, score = 700
            //   6a6f                 | push                0x6f
            //   668945d4             | mov                 word ptr [ebp - 0x2c], ax
            //   58                   | pop                 eax
            //   6a6e                 | push                0x6e
            //   5a                   | pop                 edx
            //   6a74                 | push                0x74

        $sequence_5 = { 7417 ba00010000 8bc8 c60100 41 83ea01 75f7 }
            // n = 7, score = 700
            //   7417                 | je                  0x19
            //   ba00010000           | mov                 edx, 0x100
            //   8bc8                 | mov                 ecx, eax
            //   c60100               | mov                 byte ptr [ecx], 0
            //   41                   | inc                 ecx
            //   83ea01               | sub                 edx, 1
            //   75f7                 | jne                 0xfffffff9

        $sequence_6 = { ff75f4 68???????? 8d0441 50 e8???????? 8b4608 83c418 }
            // n = 7, score = 700
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   68????????           |                     
            //   8d0441               | lea                 eax, [ecx + eax*2]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   83c418               | add                 esp, 0x18

        $sequence_7 = { 6a02 59 03c1 50 e8???????? }
            // n = 5, score = 700
            //   6a02                 | push                2
            //   59                   | pop                 ecx
            //   03c1                 | add                 eax, ecx
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 5e 5d 83c40c c3 396f18 }
            // n = 5, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   83c40c               | add                 esp, 0xc
            //   c3                   | ret                 
            //   396f18               | cmp                 dword ptr [edi + 0x18], ebp

        $sequence_9 = { 5e 5d 5b c3 837c240800 56 }
            // n = 6, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   837c240800           | cmp                 dword ptr [esp + 8], 0
            //   56                   | push                esi

        $sequence_10 = { 5e 5d 83c408 c3 33db }
            // n = 5, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   83c408               | add                 esp, 8
            //   c3                   | ret                 
            //   33db                 | xor                 ebx, ebx

        $sequence_11 = { 5e 5d 5b 83c420 c3 8b442424 68???????? }
            // n = 7, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   83c420               | add                 esp, 0x20
            //   c3                   | ret                 
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   68????????           |                     

        $sequence_12 = { 5e 5d 5b 83c410 c3 837c242c00 }
            // n = 6, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   83c410               | add                 esp, 0x10
            //   c3                   | ret                 
            //   837c242c00           | cmp                 dword ptr [esp + 0x2c], 0

        $sequence_13 = { 5e 5d 8919 33c0 5b 59 }
            // n = 6, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   8919                 | mov                 dword ptr [ecx], ebx
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx

        $sequence_14 = { 57 8b38 8b8f30870000 8baf28010000 }
            // n = 4, score = 300
            //   57                   | push                edi
            //   8b38                 | mov                 edi, dword ptr [eax]
            //   8b8f30870000         | mov                 ecx, dword ptr [edi + 0x8730]
            //   8baf28010000         | mov                 ebp, dword ptr [edi + 0x128]

        $sequence_15 = { 5e 5d 8bc3 5b 83c410 c3 8b464c }
            // n = 7, score = 300
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   8bc3                 | mov                 eax, ebx
            //   5b                   | pop                 ebx
            //   83c410               | add                 esp, 0x10
            //   c3                   | ret                 
            //   8b464c               | mov                 eax, dword ptr [esi + 0x4c]

    condition:
        7 of them and filesize < 999424
}