rule win_sykipot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sykipot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sykipot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89842420030000 b93e000000 33c0 8dbc2424030000 f3ab ff15???????? 50 }
            // n = 7, score = 200
            //   89842420030000       | mov                 dword ptr [esp + 0x320], eax
            //   b93e000000           | mov                 ecx, 0x3e
            //   33c0                 | xor                 eax, eax
            //   8dbc2424030000       | lea                 edi, [esp + 0x324]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_1 = { f3a4 ffd3 83c408 a3???????? 85c0 }
            // n = 5, score = 200
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   ffd3                 | call                ebx
            //   83c408               | add                 esp, 8
            //   a3????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 8d8c2418030000 68???????? 51 ffd7 83c408 85c0 }
            // n = 6, score = 200
            //   8d8c2418030000       | lea                 ecx, [esp + 0x318]
            //   68????????           |                     
            //   51                   | push                ecx
            //   ffd7                 | call                edi
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax

        $sequence_3 = { 68???????? 68???????? 8bf0 ffd5 83c414 3bc3 }
            // n = 6, score = 200
            //   68????????           |                     
            //   68????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   ffd5                 | call                ebp
            //   83c414               | add                 esp, 0x14
            //   3bc3                 | cmp                 eax, ebx

        $sequence_4 = { 8bcd 4f c1e902 f3a5 8bcd 8d842488000000 }
            // n = 6, score = 200
            //   8bcd                 | mov                 ecx, ebp
            //   4f                   | dec                 edi
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bcd                 | mov                 ecx, ebp
            //   8d842488000000       | lea                 eax, [esp + 0x88]

        $sequence_5 = { 895304 8bd7 895308 8bd4 8902 }
            // n = 5, score = 200
            //   895304               | mov                 dword ptr [ebx + 4], edx
            //   8bd7                 | mov                 edx, edi
            //   895308               | mov                 dword ptr [ebx + 8], edx
            //   8bd4                 | mov                 edx, esp
            //   8902                 | mov                 dword ptr [edx], eax

        $sequence_6 = { 52 68f3010000 50 56 ffd7 85c0 74ae }
            // n = 7, score = 200
            //   52                   | push                edx
            //   68f3010000           | push                0x1f3
            //   50                   | push                eax
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   74ae                 | je                  0xffffffb0

        $sequence_7 = { 8b44241c 85c0 0f84c8000000 55 50 }
            // n = 5, score = 200
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   85c0                 | test                eax, eax
            //   0f84c8000000         | je                  0xce
            //   55                   | push                ebp
            //   50                   | push                eax

        $sequence_8 = { f3ab 8b0d???????? a1???????? 898c2418030000 89842420030000 b93e000000 }
            // n = 6, score = 200
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b0d????????         |                     
            //   a1????????           |                     
            //   898c2418030000       | mov                 dword ptr [esp + 0x318], ecx
            //   89842420030000       | mov                 dword ptr [esp + 0x320], eax
            //   b93e000000           | mov                 ecx, 0x3e

        $sequence_9 = { 6a00 8d842414020000 6a1a 50 6a00 ff15???????? }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   8d842414020000       | lea                 eax, [esp + 0x214]
            //   6a1a                 | push                0x1a
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 286720
}