rule win_synccrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.synccrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.synccrypt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7442404???????? 892c24 e8???????? 85c0 0f8efdfdffff 83bc240c010000ff 8b442450 }
            // n = 7, score = 100
            //   c7442404????????     |                     
            //   892c24               | mov                 dword ptr [esp], ebp
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8efdfdffff         | jle                 0xfffffe03
            //   83bc240c010000ff     | cmp                 dword ptr [esp + 0x10c], -1
            //   8b442450             | mov                 eax, dword ptr [esp + 0x50]

        $sequence_1 = { c744240491000000 c7042422000000 e8???????? 8b4508 c7442414cb2d5900 89442418 8b4504 }
            // n = 7, score = 100
            //   c744240491000000     | mov                 dword ptr [esp + 4], 0x91
            //   c7042422000000       | mov                 dword ptr [esp], 0x22
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c7442414cb2d5900     | mov                 dword ptr [esp + 0x14], 0x592dcb
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   8b4504               | mov                 eax, dword ptr [ebp + 4]

        $sequence_2 = { c7442404???????? 891424 894c2448 e8???????? 85c0 8944243c 8b4c2448 }
            // n = 7, score = 100
            //   c7442404????????     |                     
            //   891424               | mov                 dword ptr [esp], edx
            //   894c2448             | mov                 dword ptr [esp + 0x48], ecx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   8944243c             | mov                 dword ptr [esp + 0x3c], eax
            //   8b4c2448             | mov                 ecx, dword ptr [esp + 0x48]

        $sequence_3 = { e8???????? 8d8d4832fcff e8???????? 8b85e02afcff 890424 e8???????? 8b85dc2afcff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8d4832fcff         | lea                 ecx, [ebp - 0x3cdb8]
            //   e8????????           |                     
            //   8b85e02afcff         | mov                 eax, dword ptr [ebp - 0x3d520]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b85dc2afcff         | mov                 eax, dword ptr [ebp - 0x3d524]

        $sequence_4 = { 89442434 83c420 5b 5e 5f e9???????? c74424109d000000 }
            // n = 7, score = 100
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   83c420               | add                 esp, 0x20
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   e9????????           |                     
            //   c74424109d000000     | mov                 dword ptr [esp + 0x10], 0x9d

        $sequence_5 = { c1ff1f c1fa02 89d3 bad34d6210 f7ea 29fb c1fa06 }
            // n = 7, score = 100
            //   c1ff1f               | sar                 edi, 0x1f
            //   c1fa02               | sar                 edx, 2
            //   89d3                 | mov                 ebx, edx
            //   bad34d6210           | mov                 edx, 0x10624dd3
            //   f7ea                 | imul                edx
            //   29fb                 | sub                 ebx, edi
            //   c1fa06               | sar                 edx, 6

        $sequence_6 = { 8d842480000000 890424 e8???????? 81c42c020000 31c0 5b 5e }
            // n = 7, score = 100
            //   8d842480000000       | lea                 eax, [esp + 0x80]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   81c42c020000         | add                 esp, 0x22c
            //   31c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

        $sequence_7 = { 89442404 8b442420 8b4010 8b4014 83c014 890424 e8???????? }
            // n = 7, score = 100
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   8b4014               | mov                 eax, dword ptr [eax + 0x14]
            //   83c014               | add                 eax, 0x14
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_8 = { 893c24 e8???????? 8b442420 85c0 0f95442427 ebd0 8b460c }
            // n = 7, score = 100
            //   893c24               | mov                 dword ptr [esp], edi
            //   e8????????           |                     
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   85c0                 | test                eax, eax
            //   0f95442427           | setne               byte ptr [esp + 0x27]
            //   ebd0                 | jmp                 0xffffffd2
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]

        $sequence_9 = { e8???????? 8b442434 c744240400000000 890424 e8???????? 8b842494000000 893424 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b842494000000       | mov                 eax, dword ptr [esp + 0x94]
            //   893424               | mov                 dword ptr [esp], esi

    condition:
        7 of them and filesize < 4489216
}