rule win_taidoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.taidoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.taidoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7433 ff750c 889c05f4fbffff 50 8d85f4fbffff 6a01 50 }
            // n = 7, score = 300
            //   7433                 | je                  0x35
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   889c05f4fbffff       | mov                 byte ptr [ebp + eax - 0x40c], bl
            //   50                   | push                eax
            //   8d85f4fbffff         | lea                 eax, [ebp - 0x40c]
            //   6a01                 | push                1
            //   50                   | push                eax

        $sequence_1 = { 395d10 7e1b 56 8b450c }
            // n = 4, score = 300
            //   395d10               | cmp                 dword ptr [ebp + 0x10], ebx
            //   7e1b                 | jle                 0x1d
            //   56                   | push                esi
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_2 = { 897df0 50 56 e8???????? 8b3d???????? 83f86f 750c }
            // n = 7, score = 300
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b3d????????         |                     
            //   83f86f               | cmp                 eax, 0x6f
            //   750c                 | jne                 0xe

        $sequence_3 = { 83a00401000000 b001 c9 c20800 8b8104010000 }
            // n = 5, score = 300
            //   83a00401000000       | and                 dword ptr [eax + 0x104], 0
            //   b001                 | mov                 al, 1
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   8b8104010000         | mov                 eax, dword ptr [ecx + 0x104]

        $sequence_4 = { 7e24 8a0406 fec0 3c3a 8845ec }
            // n = 5, score = 300
            //   7e24                 | jle                 0x26
            //   8a0406               | mov                 al, byte ptr [esi + eax]
            //   fec0                 | inc                 al
            //   3c3a                 | cmp                 al, 0x3a
            //   8845ec               | mov                 byte ptr [ebp - 0x14], al

        $sequence_5 = { 57 a0???????? c745fc01000000 8ac8 f6d9 1bc9 33db }
            // n = 7, score = 300
            //   57                   | push                edi
            //   a0????????           |                     
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   8ac8                 | mov                 cl, al
            //   f6d9                 | neg                 cl
            //   1bc9                 | sbb                 ecx, ecx
            //   33db                 | xor                 ebx, ebx

        $sequence_6 = { b940420f00 f7f9 8d45e0 52 ff35???????? ff35???????? }
            // n = 6, score = 300
            //   b940420f00           | mov                 ecx, 0xf4240
            //   f7f9                 | idiv                ecx
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   52                   | push                edx
            //   ff35????????         |                     
            //   ff35????????         |                     

        $sequence_7 = { e9???????? 8d4de0 e8???????? 8d8588f7ffff 50 ff35???????? ffd6 }
            // n = 7, score = 300
            //   e9????????           |                     
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   e8????????           |                     
            //   8d8588f7ffff         | lea                 eax, [ebp - 0x878]
            //   50                   | push                eax
            //   ff35????????         |                     
            //   ffd6                 | call                esi

        $sequence_8 = { ff75ec 8d4df0 e8???????? 8b450c 46 3b70f8 7cdc }
            // n = 7, score = 300
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   46                   | inc                 esi
            //   3b70f8               | cmp                 esi, dword ptr [eax - 8]
            //   7cdc                 | jl                  0xffffffde

        $sequence_9 = { 53 50 53 c7458844000000 }
            // n = 4, score = 300
            //   53                   | push                ebx
            //   50                   | push                eax
            //   53                   | push                ebx
            //   c7458844000000       | mov                 dword ptr [ebp - 0x78], 0x44

    condition:
        7 of them and filesize < 49152
}