rule win_tapaoux_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tapaoux."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tapaoux"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 8a06 51 50 4e e8???????? 83c408 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   8a06                 | mov                 al, byte ptr [esi]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   4e                   | dec                 esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_1 = { e8???????? 8bd0 83c404 85d2 7503 c21400 53 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   83c404               | add                 esp, 4
            //   85d2                 | test                edx, edx
            //   7503                 | jne                 5
            //   c21400               | ret                 0x14
            //   53                   | push                ebx

        $sequence_2 = { 6a04 8d8c241c040000 68???????? 51 e8???????? 83c40c 85c0 }
            // n = 7, score = 200
            //   6a04                 | push                4
            //   8d8c241c040000       | lea                 ecx, [esp + 0x41c]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax

        $sequence_3 = { 8bfb 8bf1 55 c1e902 f3ab }
            // n = 5, score = 200
            //   8bfb                 | mov                 edi, ebx
            //   8bf1                 | mov                 esi, ecx
            //   55                   | push                ebp
            //   c1e902               | shr                 ecx, 2
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_4 = { e8???????? 8bc5 5d 5f 5e 81c40c080000 c3 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bc5                 | mov                 eax, ebp
            //   5d                   | pop                 ebp
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   81c40c080000         | add                 esp, 0x80c
            //   c3                   | ret                 

        $sequence_5 = { 81ec1c020000 53 56 8bb42428020000 57 85f6 0f8410010000 }
            // n = 7, score = 200
            //   81ec1c020000         | sub                 esp, 0x21c
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8bb42428020000       | mov                 esi, dword ptr [esp + 0x228]
            //   57                   | push                edi
            //   85f6                 | test                esi, esi
            //   0f8410010000         | je                  0x116

        $sequence_6 = { 81ec44040000 55 57 b91f000000 33c0 8d7c2409 c644240800 }
            // n = 7, score = 200
            //   81ec44040000         | sub                 esp, 0x444
            //   55                   | push                ebp
            //   57                   | push                edi
            //   b91f000000           | mov                 ecx, 0x1f
            //   33c0                 | xor                 eax, eax
            //   8d7c2409             | lea                 edi, [esp + 9]
            //   c644240800           | mov                 byte ptr [esp + 8], 0

        $sequence_7 = { b91f000000 33c0 8dbc2491000000 889c2490000000 885c2410 f3ab }
            // n = 6, score = 200
            //   b91f000000           | mov                 ecx, 0x1f
            //   33c0                 | xor                 eax, eax
            //   8dbc2491000000       | lea                 edi, [esp + 0x91]
            //   889c2490000000       | mov                 byte ptr [esp + 0x90], bl
            //   885c2410             | mov                 byte ptr [esp + 0x10], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_8 = { 8d8424b4000000 83e103 6a01 f3a4 50 8d4c241c e8???????? }
            // n = 7, score = 200
            //   8d8424b4000000       | lea                 eax, [esp + 0xb4]
            //   83e103               | and                 ecx, 3
            //   6a01                 | push                1
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   50                   | push                eax
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   e8????????           |                     

        $sequence_9 = { 74c5 3bf7 7ccf 5f 5e 5d }
            // n = 6, score = 200
            //   74c5                 | je                  0xffffffc7
            //   3bf7                 | cmp                 esi, edi
            //   7ccf                 | jl                  0xffffffd1
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 294912
}