rule win_targetcompany_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.targetcompany."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.targetcompany"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c424 8d8574ffffff 50 8d85ecdcffff 50 ff15???????? }
            // n = 7, score = 500
            //   e8????????           |                     
            //   83c424               | add                 esp, 0x24
            //   8d8574ffffff         | lea                 eax, [ebp - 0x8c]
            //   50                   | push                eax
            //   8d85ecdcffff         | lea                 eax, [ebp - 0x2314]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { 75f1 8db57cffffff e8???????? 8bf0 }
            // n = 4, score = 500
            //   75f1                 | jne                 0xfffffff3
            //   8db57cffffff         | lea                 esi, [ebp - 0x84]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_2 = { 8945e4 3d01010000 7d0d 8a4c181c 8888d8e84100 40 ebe9 }
            // n = 7, score = 500
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   3d01010000           | cmp                 eax, 0x101
            //   7d0d                 | jge                 0xf
            //   8a4c181c             | mov                 cl, byte ptr [eax + ebx + 0x1c]
            //   8888d8e84100         | mov                 byte ptr [eax + 0x41e8d8], cl
            //   40                   | inc                 eax
            //   ebe9                 | jmp                 0xffffffeb

        $sequence_3 = { c20800 56 8bf0 81fffeffff7f 7605 e8???????? 8b4618 }
            // n = 7, score = 500
            //   c20800               | ret                 8
            //   56                   | push                esi
            //   8bf0                 | mov                 esi, eax
            //   81fffeffff7f         | cmp                 edi, 0x7ffffffe
            //   7605                 | jbe                 7
            //   e8????????           |                     
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]

        $sequence_4 = { a5 ff759c 895dd0 53 6a40 ff15???????? 8bf0 }
            // n = 7, score = 500
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   ff759c               | push                dword ptr [ebp - 0x64]
            //   895dd0               | mov                 dword ptr [ebp - 0x30], ebx
            //   53                   | push                ebx
            //   6a40                 | push                0x40
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { 6a01 68???????? 33db 53 e8???????? 85c0 7c56 }
            // n = 7, score = 500
            //   6a01                 | push                1
            //   68????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7c56                 | jl                  0x58

        $sequence_6 = { 8d45f8 50 6a1f 53 897de4 8975f8 ff15???????? }
            // n = 7, score = 500
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   6a1f                 | push                0x1f
            //   53                   | push                ebx
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   ff15????????         |                     

        $sequence_7 = { 33c5 8945fc 53 56 57 8d9dccf9ffff 8bf9 }
            // n = 7, score = 500
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d9dccf9ffff         | lea                 ebx, [ebp - 0x634]
            //   8bf9                 | mov                 edi, ecx

        $sequence_8 = { 56 57 8945f4 8945f8 3905???????? 7516 8b0d???????? }
            // n = 7, score = 500
            //   56                   | push                esi
            //   57                   | push                edi
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   3905????????         |                     
            //   7516                 | jne                 0x18
            //   8b0d????????         |                     

        $sequence_9 = { 25ffff7f00 c1e108 33d2 0bc8 0bda 8bc1 8b4df8 }
            // n = 7, score = 500
            //   25ffff7f00           | and                 eax, 0x7fffff
            //   c1e108               | shl                 ecx, 8
            //   33d2                 | xor                 edx, edx
            //   0bc8                 | or                  ecx, eax
            //   0bda                 | or                  ebx, edx
            //   8bc1                 | mov                 eax, ecx
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

    condition:
        7 of them and filesize < 328704
}