rule win_telepowerbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.telepowerbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.telepowerbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8579010000 8b35???????? 68a6000000 68???????? 6a01 50 }
            // n = 6, score = 200
            //   0f8579010000         | jne                 0x17f
            //   8b35????????         |                     
            //   68a6000000           | push                0xa6
            //   68????????           |                     
            //   6a01                 | push                1
            //   50                   | push                eax

        $sequence_1 = { ffd3 85c0 7530 6a32 }
            // n = 4, score = 200
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   7530                 | jne                 0x32
            //   6a32                 | push                0x32

        $sequence_2 = { c1f806 6bc938 8b0485f09d4100 0fb6440828 83e040 5d }
            // n = 6, score = 200
            //   c1f806               | sar                 eax, 6
            //   6bc938               | imul                ecx, ecx, 0x38
            //   8b0485f09d4100       | mov                 eax, dword ptr [eax*4 + 0x419df0]
            //   0fb6440828           | movzx               eax, byte ptr [eax + ecx + 0x28]
            //   83e040               | and                 eax, 0x40
            //   5d                   | pop                 ebp

        $sequence_3 = { c745e4a8604100 eb07 c745e494604100 8b4508 }
            // n = 4, score = 200
            //   c745e4a8604100       | mov                 dword ptr [ebp - 0x1c], 0x4160a8
            //   eb07                 | jmp                 9
            //   c745e494604100       | mov                 dword ptr [ebp - 0x1c], 0x416094
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_4 = { 8b04bdf09d4100 ff743018 ff15???????? 85c0 7404 }
            // n = 5, score = 200
            //   8b04bdf09d4100       | mov                 eax, dword ptr [edi*4 + 0x419df0]
            //   ff743018             | push                dword ptr [eax + esi + 0x18]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6

        $sequence_5 = { 56 57 e8???????? 57 68???????? 53 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     
            //   57                   | push                edi
            //   68????????           |                     
            //   53                   | push                ebx

        $sequence_6 = { 85f6 7420 6bc618 57 8db8f09b4100 }
            // n = 5, score = 200
            //   85f6                 | test                esi, esi
            //   7420                 | je                  0x22
            //   6bc618               | imul                eax, esi, 0x18
            //   57                   | push                edi
            //   8db8f09b4100         | lea                 edi, [eax + 0x419bf0]

        $sequence_7 = { 83e03f c1f906 6bd038 8b45fc 03148df09d4100 }
            // n = 5, score = 200
            //   83e03f               | and                 eax, 0x3f
            //   c1f906               | sar                 ecx, 6
            //   6bd038               | imul                edx, eax, 0x38
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   03148df09d4100       | add                 edx, dword ptr [ecx*4 + 0x419df0]

        $sequence_8 = { 83e73f c1f906 6bd738 8b0c8df09d4100 c644112800 }
            // n = 5, score = 200
            //   83e73f               | and                 edi, 0x3f
            //   c1f906               | sar                 ecx, 6
            //   6bd738               | imul                edx, edi, 0x38
            //   8b0c8df09d4100       | mov                 ecx, dword ptr [ecx*4 + 0x419df0]
            //   c644112800           | mov                 byte ptr [ecx + edx + 0x28], 0

        $sequence_9 = { 8bcf 83e03f c1f906 6bd038 8b45fc 03148df09d4100 }
            // n = 6, score = 200
            //   8bcf                 | mov                 ecx, edi
            //   83e03f               | and                 eax, 0x3f
            //   c1f906               | sar                 ecx, 6
            //   6bd038               | imul                edx, eax, 0x38
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   03148df09d4100       | add                 edx, dword ptr [ecx*4 + 0x419df0]

    condition:
        7 of them and filesize < 237568
}