rule win_tflower_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tflower."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tflower"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0001 0200 0103 0303 }
            // n = 4, score = 200
            //   0001                 | add                 byte ptr [ecx], al
            //   0200                 | add                 al, byte ptr [eax]
            //   0103                 | add                 dword ptr [ebx], eax
            //   0303                 | add                 eax, dword ptr [ebx]

        $sequence_1 = { 0001 7708 00f3 7608 }
            // n = 4, score = 200
            //   0001                 | add                 byte ptr [ecx], al
            //   7708                 | ja                  0xa
            //   00f3                 | add                 bl, dh
            //   7608                 | jbe                 0xa

        $sequence_2 = { 0002 7408 00f7 7308 }
            // n = 4, score = 200
            //   0002                 | add                 byte ptr [edx], al
            //   7408                 | je                  0xa
            //   00f7                 | add                 bh, dh
            //   7308                 | jae                 0xa

        $sequence_3 = { c1e810 8bcb c1e918 0fb6c0 8b0c8dc0064f00 330c85c0024f00 }
            // n = 6, score = 200
            //   c1e810               | shr                 eax, 0x10
            //   8bcb                 | mov                 ecx, ebx
            //   c1e918               | shr                 ecx, 0x18
            //   0fb6c0               | movzx               eax, al
            //   8b0c8dc0064f00       | mov                 ecx, dword ptr [ecx*4 + 0x4f06c0]
            //   330c85c0024f00       | xor                 ecx, dword ptr [eax*4 + 0x4f02c0]

        $sequence_4 = { 0008 7408 0002 7408 }
            // n = 4, score = 200
            //   0008                 | add                 byte ptr [eax], cl
            //   7408                 | je                  0xa
            //   0002                 | add                 byte ptr [edx], al
            //   7408                 | je                  0xa

        $sequence_5 = { 0beb 33ff 8b1c8d48fa4e00 8b4c2418 }
            // n = 4, score = 200
            //   0beb                 | or                  ebp, ebx
            //   33ff                 | xor                 edi, edi
            //   8b1c8d48fa4e00       | mov                 ebx, dword ptr [ecx*4 + 0x4efa48]
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]

        $sequence_6 = { 000f 7708 0001 7708 }
            // n = 4, score = 200
            //   000f                 | add                 byte ptr [edi], cl
            //   7708                 | ja                  0xa
            //   0001                 | add                 byte ptr [ecx], al
            //   7708                 | ja                  0xa

        $sequence_7 = { 0bc8 51 e8???????? 83c404 8906 8d4df4 }
            // n = 6, score = 200
            //   0bc8                 | or                  ecx, eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8906                 | mov                 dword ptr [esi], eax
            //   8d4df4               | lea                 ecx, [ebp - 0xc]

        $sequence_8 = { 0010 740b 0021 740b }
            // n = 4, score = 200
            //   0010                 | add                 byte ptr [eax], dl
            //   740b                 | je                  0xd
            //   0021                 | add                 byte ptr [ecx], ah
            //   740b                 | je                  0xd

        $sequence_9 = { 8bcb c1e910 0fb6d1 8b349510674f00 }
            // n = 4, score = 200
            //   8bcb                 | mov                 ecx, ebx
            //   c1e910               | shr                 ecx, 0x10
            //   0fb6d1               | movzx               edx, cl
            //   8b349510674f00       | mov                 esi, dword ptr [edx*4 + 0x4f6710]

        $sequence_10 = { 001a 0c05 003c0c 05004e0c05 }
            // n = 4, score = 200
            //   001a                 | add                 byte ptr [edx], bl
            //   0c05                 | or                  al, 5
            //   003c0c               | add                 byte ptr [esp + ecx], bh
            //   05004e0c05           | add                 eax, 0x50c4e00

        $sequence_11 = { 0fb64802 8d41ff 83f87f 0f8791000000 0fb680180e4900 ff2485f40d4900 68???????? }
            // n = 7, score = 200
            //   0fb64802             | movzx               ecx, byte ptr [eax + 2]
            //   8d41ff               | lea                 eax, [ecx - 1]
            //   83f87f               | cmp                 eax, 0x7f
            //   0f8791000000         | ja                  0x97
            //   0fb680180e4900       | movzx               eax, byte ptr [eax + 0x490e18]
            //   ff2485f40d4900       | jmp                 dword ptr [eax*4 + 0x490df4]
            //   68????????           |                     

        $sequence_12 = { 50 6a00 6a00 8d85f0fcffff }
            // n = 4, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d85f0fcffff         | lea                 eax, [ebp - 0x310]

        $sequence_13 = { 3304bd20d14e00 8b7c243c 8b542420 c1ea18 3304bd20c94e00 8b7c2448 }
            // n = 6, score = 200
            //   3304bd20d14e00       | xor                 eax, dword ptr [edi*4 + 0x4ed120]
            //   8b7c243c             | mov                 edi, dword ptr [esp + 0x3c]
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]
            //   c1ea18               | shr                 edx, 0x18
            //   3304bd20c94e00       | xor                 eax, dword ptr [edi*4 + 0x4ec920]
            //   8b7c2448             | mov                 edi, dword ptr [esp + 0x48]

        $sequence_14 = { c1e810 0fb6c0 8b0c8520e54e00 8b44242c }
            // n = 4, score = 200
            //   c1e810               | shr                 eax, 0x10
            //   0fb6c0               | movzx               eax, al
            //   8b0c8520e54e00       | mov                 ecx, dword ptr [eax*4 + 0x4ee520]
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]

        $sequence_15 = { 000b 8605???????? 007885 0500788605 }
            // n = 4, score = 200
            //   000b                 | add                 byte ptr [ebx], cl
            //   8605????????         |                     
            //   007885               | add                 byte ptr [eax - 0x7b], bh
            //   0500788605           | add                 eax, 0x5867800

    condition:
        7 of them and filesize < 6578176
}