rule win_thumbthief_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.thumbthief."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.thumbthief"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d84246c010000 50 8d8424e4000000 50 8d842488010000 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d84246c010000       | lea                 eax, [esp + 0x16c]
            //   50                   | push                eax
            //   8d8424e4000000       | lea                 eax, [esp + 0xe4]
            //   50                   | push                eax
            //   8d842488010000       | lea                 eax, [esp + 0x188]
            //   50                   | push                eax

        $sequence_1 = { f3a5 66318568feffff 66a5 8db56effffff bf0d000000 0fb74602 8d76f6 }
            // n = 7, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   66318568feffff       | xor                 word ptr [ebp - 0x198], ax
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   8db56effffff         | lea                 esi, [ebp - 0x92]
            //   bf0d000000           | mov                 edi, 0xd
            //   0fb74602             | movzx               eax, word ptr [esi + 2]
            //   8d76f6               | lea                 esi, [esi - 0xa]

        $sequence_2 = { e9???????? 8d8d2cffffff e9???????? 8d4d90 e9???????? 8d4dc4 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d8d2cffffff         | lea                 ecx, [ebp - 0xd4]
            //   e9????????           |                     
            //   8d4d90               | lea                 ecx, [ebp - 0x70]
            //   e9????????           |                     
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   e9????????           |                     

        $sequence_3 = { e8???????? 8d8584feffff 50 e8???????? ffb594feffff 8d8da0feffff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8584feffff         | lea                 eax, [ebp - 0x17c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   ffb594feffff         | push                dword ptr [ebp - 0x16c]
            //   8d8da0feffff         | lea                 ecx, [ebp - 0x160]
            //   e8????????           |                     

        $sequence_4 = { ff7518 68???????? 57 e8???????? 83c410 e9???????? 8b5040 }
            // n = 7, score = 100
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   e9????????           |                     
            //   8b5040               | mov                 edx, dword ptr [eax + 0x40]

        $sequence_5 = { ff742438 33c0 85c9 ff7514 0f99c0 8bcf 6a00 }
            // n = 7, score = 100
            //   ff742438             | push                dword ptr [esp + 0x38]
            //   33c0                 | xor                 eax, eax
            //   85c9                 | test                ecx, ecx
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   0f99c0               | setns               al
            //   8bcf                 | mov                 ecx, edi
            //   6a00                 | push                0

        $sequence_6 = { e8???????? c645fc06 8d8d28ffffff e8???????? c645fc07 8d8d3cffffff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c645fc06             | mov                 byte ptr [ebp - 4], 6
            //   8d8d28ffffff         | lea                 ecx, [ebp - 0xd8]
            //   e8????????           |                     
            //   c645fc07             | mov                 byte ptr [ebp - 4], 7
            //   8d8d3cffffff         | lea                 ecx, [ebp - 0xc4]
            //   e8????????           |                     

        $sequence_7 = { e8???????? 837db800 8945b0 0f85c0000000 8b4d9c 8b4724 8945ac }
            // n = 7, score = 100
            //   e8????????           |                     
            //   837db800             | cmp                 dword ptr [ebp - 0x48], 0
            //   8945b0               | mov                 dword ptr [ebp - 0x50], eax
            //   0f85c0000000         | jne                 0xc6
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   8b4724               | mov                 eax, dword ptr [edi + 0x24]
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax

        $sequence_8 = { e9???????? 8d8d1cffffff e9???????? 8d8d6cffffff e9???????? 8d8d08ffffff e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d8d1cffffff         | lea                 ecx, [ebp - 0xe4]
            //   e9????????           |                     
            //   8d8d6cffffff         | lea                 ecx, [ebp - 0x94]
            //   e9????????           |                     
            //   8d8d08ffffff         | lea                 ecx, [ebp - 0xf8]
            //   e9????????           |                     

        $sequence_9 = { 8d8c24f8000000 6a0d e8???????? 68???????? 8d8424f4000000 e9???????? 8d8424c8000000 }
            // n = 7, score = 100
            //   8d8c24f8000000       | lea                 ecx, [esp + 0xf8]
            //   6a0d                 | push                0xd
            //   e8????????           |                     
            //   68????????           |                     
            //   8d8424f4000000       | lea                 eax, [esp + 0xf4]
            //   e9????????           |                     
            //   8d8424c8000000       | lea                 eax, [esp + 0xc8]

    condition:
        7 of them and filesize < 4235264
}