rule win_tinytyphon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tinytyphon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinytyphon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? ebea 6a00 6a00 8d95f8feffff }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   ebea                 | jmp                 0xffffffec
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d95f8feffff         | lea                 edx, [ebp - 0x108]

        $sequence_1 = { 8955f0 8d45d8 50 ff15???????? 8945d0 8b4df0 3b4dd0 }
            // n = 7, score = 200
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   3b4dd0               | cmp                 ecx, dword ptr [ebp - 0x30]

        $sequence_2 = { 034160 8b55dc 8d8402bbd2d72a 8945dc }
            // n = 4, score = 200
            //   034160               | add                 eax, dword ptr [ecx + 0x60]
            //   8b55dc               | mov                 edx, dword ptr [ebp - 0x24]
            //   8d8402bbd2d72a       | lea                 eax, [edx + eax + 0x2ad7d2bb]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax

        $sequence_3 = { 6a13 8b85e8feffff 50 ff15???????? 85c0 7544 }
            // n = 6, score = 200
            //   6a13                 | push                0x13
            //   8b85e8feffff         | mov                 eax, dword ptr [ebp - 0x118]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7544                 | jne                 0x46

        $sequence_4 = { c1e108 0bd1 8b45f4 0fb6480e c1e110 0bd1 8b45f4 }
            // n = 7, score = 200
            //   c1e108               | shl                 ecx, 8
            //   0bd1                 | or                  edx, ecx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   0fb6480e             | movzx               ecx, byte ptr [eax + 0xe]
            //   c1e110               | shl                 ecx, 0x10
            //   0bd1                 | or                  edx, ecx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_5 = { 668955fc 33c0 668945fc eb0c 668b4dfc 6683c101 66894dfc }
            // n = 7, score = 200
            //   668955fc             | mov                 word ptr [ebp - 4], dx
            //   33c0                 | xor                 eax, eax
            //   668945fc             | mov                 word ptr [ebp - 4], ax
            //   eb0c                 | jmp                 0xe
            //   668b4dfc             | mov                 cx, word ptr [ebp - 4]
            //   6683c101             | add                 cx, 1
            //   66894dfc             | mov                 word ptr [ebp - 4], cx

        $sequence_6 = { 8b5508 034a78 8b45e0 8d8c0881f67187 894de0 8b55e0 }
            // n = 6, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   034a78               | add                 ecx, dword ptr [edx + 0x78]
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8d8c0881f67187       | lea                 ecx, [eax + ecx - 0x788e097f]
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]

        $sequence_7 = { 034160 8b55e4 8d84026556acc4 8945e4 8b4de4 c1e117 8b55e4 }
            // n = 7, score = 200
            //   034160               | add                 eax, dword ptr [ecx + 0x60]
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   8d84026556acc4       | lea                 eax, [edx + eax - 0x3b53a99b]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   c1e117               | shl                 ecx, 0x17
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]

        $sequence_8 = { 034de4 894df8 8b55f4 0fb64204 8b4df4 0fb65105 c1e208 }
            // n = 7, score = 200
            //   034de4               | add                 ecx, dword ptr [ebp - 0x1c]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   0fb64204             | movzx               eax, byte ptr [edx + 4]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   0fb65105             | movzx               edx, byte ptr [ecx + 5]
            //   c1e208               | shl                 edx, 8

        $sequence_9 = { 8b4de4 c1e116 8b55e4 c1ea0a 0bca 894de4 8b45e4 }
            // n = 7, score = 200
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   c1e116               | shl                 ecx, 0x16
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   c1ea0a               | shr                 edx, 0xa
            //   0bca                 | or                  ecx, edx
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

    condition:
        7 of them and filesize < 90112
}