rule win_tonerjam_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tonerjam."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tonerjam"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b902000000 cd29 488d0d1ee10100 e8???????? 488b442438 488905???????? 488d442438 }
            // n = 7, score = 100
            //   b902000000           | inc                 esp
            //   cd29                 | mov                 esi, ebx
            //   488d0d1ee10100       | dec                 ecx
            //   e8????????           |                     
            //   488b442438           | mov                 eax, ebp
            //   488905????????       |                     
            //   488d442438           | lea                 ebp, [ebx + 1]

        $sequence_1 = { 488d3547500100 48895c2420 488d0593660100 483bd8 7419 483933 740e }
            // n = 7, score = 100
            //   488d3547500100       | xor                 ecx, ecx
            //   48895c2420           | inc                 ebp
            //   488d0593660100       | lea                 eax, [ecx + 0x20]
            //   483bd8               | test                eax, eax
            //   7419                 | je                  0xd2c
            //   483933               | dec                 esp
            //   740e                 | mov                 eax, dword ptr [esp + 0x48]

        $sequence_2 = { ff15???????? 488b8dd00d0000 4833cd e8???????? 488b9df00d0000 488bb5f80d0000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   488b8dd00d0000       | dec                 eax
            //   4833cd               | mov                 ecx, eax
            //   e8????????           |                     
            //   488b9df00d0000       | dec                 eax
            //   488bb5f80d0000       | lea                 edx, [0x1c4d5]

        $sequence_3 = { 41b808020000 e8???????? 660f6f15???????? 488d0513e40100 33ed 448bcd f30f6f40f0 }
            // n = 7, score = 100
            //   41b808020000         | dec                 eax
            //   e8????????           |                     
            //   660f6f15????????     |                     
            //   488d0513e40100       | lea                 edx, [ebp + 0x9b0]
            //   33ed                 | dec                 eax
            //   448bcd               | lea                 ecx, [ebp + 0xbc0]
            //   f30f6f40f0           | test                eax, eax

        $sequence_4 = { 488d9424e0000000 488d144a 482bc1 7432 4c8d0d32bc0100 b9feffff7f }
            // n = 6, score = 100
            //   488d9424e0000000     | mov                 eax, 0x208
            //   488d144a             | dec                 eax
            //   482bc1               | lea                 eax, [0x1e413]
            //   7432                 | xor                 ebp, ebp
            //   4c8d0d32bc0100       | inc                 esp
            //   b9feffff7f           | mov                 ecx, ebp

        $sequence_5 = { 7474 83fb01 756a 8b0d???????? 48893d???????? e8???????? e8???????? }
            // n = 7, score = 100
            //   7474                 | dec                 eax
            //   83fb01               | mov                 ecx, dword ptr [edi]
            //   756a                 | dec                 eax
            //   8b0d????????         |                     
            //   48893d????????       |                     
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_6 = { 4c8d4c2440 488bd0 4c89742420 488bcb 488bf0 ff15???????? 4c8d4c2460 }
            // n = 7, score = 100
            //   4c8d4c2440           | test                eax, eax
            //   488bd0               | je                  0x10b
            //   4c89742420           | dec                 eax
            //   488bcb               | sub                 ebx, edi
            //   488bf0               | dec                 eax
            //   ff15????????         |                     
            //   4c8d4c2460           | mov                 edx, ebx

        $sequence_7 = { 48894604 b906000000 48898620020000 0fb7c0 66f3ab 488d3d18370100 482bfe }
            // n = 7, score = 100
            //   48894604             | mov                 ecx, 0x1b
            //   b906000000           | xor                 eax, eax
            //   48898620020000       | dec                 eax
            //   0fb7c0               | mov                 dword ptr [ebp - 0x30], eax
            //   66f3ab               | inc                 ebp
            //   488d3d18370100       | xor                 ecx, ecx
            //   482bfe               | dec                 eax

        $sequence_8 = { e8???????? 41b804010000 488d542420 33c9 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   41b804010000         | nop                 word ptr [eax + eax]
            //   488d542420           | inc                 edi
            //   33c9                 | mov                 ecx, dword ptr [edx + eax*4 + 0x25050]

        $sequence_9 = { 85c9 7858 3b15???????? 7350 488bca 4c8d05d9de0000 83e13f }
            // n = 7, score = 100
            //   85c9                 | dec                 edx
            //   7858                 | mov                 eax, dword ptr [eax + esi*8 + 0x28]
            //   3b15????????         |                     
            //   7350                 | dec                 eax
            //   488bca               | mov                 dword ptr [ebp - 0x49], eax
            //   4c8d05d9de0000       | dec                 esp
            //   83e13f               | mov                 dword ptr [ebp - 0x49], ebp

    condition:
        7 of them and filesize < 315392
}