rule win_treasurehunter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.treasurehunter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.treasurehunter"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 51 53 56 8b35???????? 8bd9 8b4d08 }
            // n = 7, score = 300
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b35????????         |                     
            //   8bd9                 | mov                 ebx, ecx
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_1 = { ba???????? 53 56 57 6a01 }
            // n = 5, score = 300
            //   ba????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a01                 | push                1

        $sequence_2 = { 8bd9 8b4d08 57 8955fc e8???????? 8bce }
            // n = 6, score = 300
            //   8bd9                 | mov                 ebx, ecx
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi

        $sequence_3 = { 56 8bf8 e8???????? 68???????? 57 e8???????? }
            // n = 6, score = 300
            //   56                   | push                esi
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_4 = { 85d2 7e0b 4a e8???????? 0fafc6 5e }
            // n = 6, score = 300
            //   85d2                 | test                edx, edx
            //   7e0b                 | jle                 0xd
            //   4a                   | dec                 edx
            //   e8????????           |                     
            //   0fafc6               | imul                eax, esi
            //   5e                   | pop                 esi

        $sequence_5 = { 57 e8???????? 83c40c be???????? ff36 }
            // n = 5, score = 300
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   be????????           |                     
            //   ff36                 | push                dword ptr [esi]

        $sequence_6 = { 6a2f 68???????? 57 ff15???????? 85c0 }
            // n = 5, score = 300
            //   6a2f                 | push                0x2f
            //   68????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { 0f47c7 50 56 53 8945fc ff15???????? }
            // n = 6, score = 300
            //   0f47c7               | cmova               eax, edi
            //   50                   | push                eax
            //   56                   | push                esi
            //   53                   | push                ebx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 229376
}