rule win_troldesh_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.troldesh."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.troldesh"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb05 8945fc 33c0 3bc3 0f85cafeffff 0375fc 8b4758 }
            // n = 7, score = 600
            //   eb05                 | jmp                 7
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   33c0                 | xor                 eax, eax
            //   3bc3                 | cmp                 eax, ebx
            //   0f85cafeffff         | jne                 0xfffffed0
            //   0375fc               | add                 esi, dword ptr [ebp - 4]
            //   8b4758               | mov                 eax, dword ptr [edi + 0x58]

        $sequence_1 = { e9???????? 8b8b70040000 83f902 7d0a 68???????? e9???????? 8b8374040000 }
            // n = 7, score = 600
            //   e9????????           |                     
            //   8b8b70040000         | mov                 ecx, dword ptr [ebx + 0x470]
            //   83f902               | cmp                 ecx, 2
            //   7d0a                 | jge                 0xc
            //   68????????           |                     
            //   e9????????           |                     
            //   8b8374040000         | mov                 eax, dword ptr [ebx + 0x474]

        $sequence_2 = { eb64 6a48 57 ff7514 e8???????? 83c40c 6a14 }
            // n = 7, score = 600
            //   eb64                 | jmp                 0x66
            //   6a48                 | push                0x48
            //   57                   | push                edi
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6a14                 | push                0x14

        $sequence_3 = { ff7508 e8???????? 83c40c 85c0 740d e8???????? 83c8ff }
            // n = 7, score = 600
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   e8????????           |                     
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_4 = { e8???????? 8b45f4 59 5e c9 c3 8b442408 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   8b442408             | mov                 eax, dword ptr [esp + 8]

        $sequence_5 = { ff30 e8???????? 59 8b75f8 834dd8ff 85f6 7408 }
            // n = 7, score = 600
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   834dd8ff             | or                  dword ptr [ebp - 0x28], 0xffffffff
            //   85f6                 | test                esi, esi
            //   7408                 | je                  0xa

        $sequence_6 = { e8???????? ff750c 8b5dec ff7508 8bf3 e8???????? ff750c }
            // n = 7, score = 600
            //   e8????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8bf3                 | mov                 esi, ebx
            //   e8????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_7 = { f6401080 7409 83bedc00000000 741a 85cf 7505 857810 }
            // n = 7, score = 600
            //   f6401080             | test                byte ptr [eax + 0x10], 0x80
            //   7409                 | je                  0xb
            //   83bedc00000000       | cmp                 dword ptr [esi + 0xdc], 0
            //   741a                 | je                  0x1c
            //   85cf                 | test                edi, ecx
            //   7505                 | jne                 7
            //   857810               | test                dword ptr [eax + 0x10], edi

        $sequence_8 = { e8???????? 8b45f4 8b7004 3bf3 0f8e12010000 895de0 e8???????? }
            // n = 7, score = 600
            //   e8????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b7004               | mov                 esi, dword ptr [eax + 4]
            //   3bf3                 | cmp                 esi, ebx
            //   0f8e12010000         | jle                 0x118
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   e8????????           |                     

        $sequence_9 = { e8???????? 85ed 751e 68???????? 56 686d030000 e8???????? }
            // n = 7, score = 600
            //   e8????????           |                     
            //   85ed                 | test                ebp, ebp
            //   751e                 | jne                 0x20
            //   68????????           |                     
            //   56                   | push                esi
            //   686d030000           | push                0x36d
            //   e8????????           |                     

    condition:
        7 of them and filesize < 3915776
}