rule win_troll_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.troll_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.troll_stealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81f3fa726602 f9 f7d3 d1cb f9 4153 }
            // n = 6, score = 100
            //   81f3fa726602         | inc                 eax
            //   f9                   | xor                 dh, 0xe9
            //   f7d3                 | dec                 ecx
            //   d1cb                 | sub                 edx, 4
            //   f9                   | rcl                 esi, 0xa2
            //   4153                 | dec                 esp

        $sequence_1 = { 4080ff09 4584c0 4863d2 f5 41f7c05471e21e 4584d2 }
            // n = 6, score = 100
            //   4080ff09             | test                ebp, 0x57964a06
            //   4584c0               | neg                 edx
            //   4863d2               | xor                 edx, 0x713c16ed
            //   f5                   | inc                 ecx
            //   41f7c05471e21e       | cmp                 bl, 0x66
            //   4584d2               | add                 edx, 0x548a222b

        $sequence_2 = { 400f91c7 66f7d7 490fb7ff 9c 480fbffc 418f00 ffc7 }
            // n = 7, score = 100
            //   400f91c7             | ror                 edx, 1
            //   66f7d7               | cmp                 ebx, ebx
            //   490fb7ff             | inc                 esp
            //   9c                   | test                edx, esp
            //   480fbffc             | inc                 ecx
            //   418f00               | push                eax
            //   ffc7                 | inc                 ecx

        $sequence_3 = { 4151 313424 6641ffc1 41b1aa 4159 4863f6 f8 }
            // n = 7, score = 100
            //   4151                 | test                ah, 0xc1
            //   313424               | xor                 dword ptr [esp], edi
            //   6641ffc1             | inc                 ecx
            //   41b1aa               | add                 bl, cl
            //   4159                 | xadd                bl, bh
            //   4863f6               | ror                 ebx, cl
            //   f8                   | pop                 ebx

        $sequence_4 = { 4180fede 4d3bf8 05963b2855 d1c8 80fc60 f9 48f7c1f132aa0d }
            // n = 7, score = 100
            //   4180fede             | test                dh, ah
            //   4d3bf8               | dec                 ecx
            //   05963b2855           | add                 ebx, 4
            //   d1c8                 | xor                 edi, ebx
            //   80fc60               | inc                 cx
            //   f9                   | test                edx, edi
            //   48f7c1f132aa0d       | inc                 eax

        $sequence_5 = { 490fb3e0 44311c24 4d0fa4c032 4523c6 4158 4d63db 443ac0 }
            // n = 7, score = 100
            //   490fb3e0             | inc                 ecx
            //   44311c24             | sub                 esi, ebx
            //   4d0fa4c032           | inc                 esp
            //   4523c6               | xor                 bl, bh
            //   4158                 | mov                 byte ptr [esp + edi], cl
            //   4d63db               | inc                 eax
            //   443ac0               | sal                 bh, 0xa1

        $sequence_6 = { 49c1c824 448ac6 66410fabd8 313424 4158 66453bea 4863f6 }
            // n = 7, score = 100
            //   49c1c824             | cmp                 ecx, 0x66b14f17
            //   448ac6               | inc                 ecx
            //   66410fabd8           | not                 ebx
            //   313424               | inc                 ecx
            //   4158                 | push                edx
            //   66453bea             | inc                 cx
            //   4863f6               | shl                 edx, cl

        $sequence_7 = { c1e004 660fb6df 660fa3c3 23f2 b326 4863d8 }
            // n = 6, score = 100
            //   c1e004               | cmp                 bl, 0xf6
            //   660fb6df             | dec                 eax
            //   660fa3c3             | add                 ebp, 4
            //   23f2                 | cmp                 bl, ch
            //   b326                 | inc                 cx
            //   4863d8               | mov                 edx, 0x489c5789

        $sequence_8 = { 6681cf754d 4981c006000000 66418928 66d3e7 4981ea04000000 413add 480fa3ef }
            // n = 7, score = 100
            //   6681cf754d           | dec                 eax
            //   4981c006000000       | shr                 edi, cl
            //   66418928             | pop                 edi
            //   66d3e7               | push                edi
            //   4981ea04000000       | xor                 dword ptr [esp], ecx
            //   413add               | inc                 eax
            //   480fa3ef             | inc                 bh

        $sequence_9 = { 66410fbaf9e4 410fb3d9 488b6c25f8 41d2c9 4d1bc3 4889442500 4c8bcd }
            // n = 7, score = 100
            //   66410fbaf9e4         | dec                 ecx
            //   410fb3d9             | sar                 ecx, cl
            //   488b6c25f8           | dec                 esp
            //   41d2c9               | mov                 ecx, ebp
            //   4d1bc3               | inc                 ecx
            //   4889442500           | pop                 eax
            //   4c8bcd               | inc                 esp

    condition:
        7 of them and filesize < 45868032
}