rule win_tsifiri_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2018-11-23"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator 0.1a"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tsifiri"
        malpedia_version = "20180607"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using yara-signator.
     * The code and documentation / approach will be published in the near future here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */

    strings:
        $sequence_0 = { ff2504104000 ff252c104000 ff2528104000 ff2518104000 }
            // n = 4, score = 1000
            //   ff2504104000         | jmp                 dword ptr [0x401004]
            //   ff252c104000         | jmp                 dword ptr [0x40102c]
            //   ff2528104000         | jmp                 dword ptr [0x401028]
            //   ff2518104000         | jmp                 dword ptr [0x401018]

        $sequence_1 = { ff252c104000 ff2528104000 ff2518104000 ff2524104000 }
            // n = 4, score = 1000
            //   ff252c104000         | jmp                 dword ptr [0x40102c]
            //   ff2528104000         | jmp                 dword ptr [0x401028]
            //   ff2518104000         | jmp                 dword ptr [0x401018]
            //   ff2524104000         | jmp                 dword ptr [0x401024]

        $sequence_2 = { ff2528104000 ff2518104000 ff2524104000 ff2500104000 }
            // n = 4, score = 1000
            //   ff2528104000         | jmp                 dword ptr [0x401028]
            //   ff2518104000         | jmp                 dword ptr [0x401018]
            //   ff2524104000         | jmp                 dword ptr [0x401024]
            //   ff2500104000         | jmp                 dword ptr [0x401000]

        $sequence_3 = { ff2534104000 ff2544104000 ff251c104000 ff2558104000 }
            // n = 4, score = 1000
            //   ff2534104000         | jmp                 dword ptr [0x401034]
            //   ff2544104000         | jmp                 dword ptr [0x401044]
            //   ff251c104000         | jmp                 dword ptr [0x40101c]
            //   ff2558104000         | jmp                 dword ptr [0x401058]

        $sequence_4 = { ff2550104000 ff2514104000 ff2554104000 ff253c104000 }
            // n = 4, score = 1000
            //   ff2550104000         | jmp                 dword ptr [0x401050]
            //   ff2514104000         | jmp                 dword ptr [0x401014]
            //   ff2554104000         | jmp                 dword ptr [0x401054]
            //   ff253c104000         | jmp                 dword ptr [0x40103c]

        $sequence_5 = { ff255c104000 ff250c104000 ff2504104000 ff252c104000 }
            // n = 4, score = 1000
            //   ff255c104000         | jmp                 dword ptr [0x40105c]
            //   ff250c104000         | jmp                 dword ptr [0x40100c]
            //   ff2504104000         | jmp                 dword ptr [0x401004]
            //   ff252c104000         | jmp                 dword ptr [0x40102c]

        $sequence_6 = { ff250c104000 ff2504104000 ff252c104000 ff2528104000 }
            // n = 4, score = 1000
            //   ff250c104000         | jmp                 dword ptr [0x40100c]
            //   ff2504104000         | jmp                 dword ptr [0x401004]
            //   ff252c104000         | jmp                 dword ptr [0x40102c]
            //   ff2528104000         | jmp                 dword ptr [0x401028]

        $sequence_7 = { ff2510104000 ff2550104000 ff2514104000 ff2554104000 }
            // n = 4, score = 1000
            //   ff2510104000         | jmp                 dword ptr [0x401010]
            //   ff2550104000         | jmp                 dword ptr [0x401050]
            //   ff2514104000         | jmp                 dword ptr [0x401014]
            //   ff2554104000         | jmp                 dword ptr [0x401054]

        $sequence_8 = { ff2548104000 ff255c104000 ff250c104000 ff2504104000 }
            // n = 4, score = 1000
            //   ff2548104000         | jmp                 dword ptr [0x401048]
            //   ff255c104000         | jmp                 dword ptr [0x40105c]
            //   ff250c104000         | jmp                 dword ptr [0x40100c]
            //   ff2504104000         | jmp                 dword ptr [0x401004]

        $sequence_9 = { ff2544104000 ff251c104000 ff2558104000 ff2530104000 }
            // n = 4, score = 1000
            //   ff2544104000         | jmp                 dword ptr [0x401044]
            //   ff251c104000         | jmp                 dword ptr [0x40101c]
            //   ff2558104000         | jmp                 dword ptr [0x401058]
            //   ff2530104000         | jmp                 dword ptr [0x401030]

    condition:
        7 of them
}