rule win_turla_silentmoon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.turla_silentmoon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.turla_silentmoon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 40 83bc85ecf7ffff00 74f5 8b7508 8b3496 ff8c85ecf7ffff }
            // n = 6, score = 300
            //   40                   | inc                 eax
            //   83bc85ecf7ffff00     | cmp                 dword ptr [ebp + eax*4 - 0x814], 0
            //   74f5                 | je                  0xfffffff7
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b3496               | mov                 esi, dword ptr [esi + edx*4]
            //   ff8c85ecf7ffff       | dec                 dword ptr [ebp + eax*4 - 0x814]

        $sequence_1 = { 8b01 8b4d10 52 8b55f4 03c3 03d3 e8???????? }
            // n = 7, score = 300
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   52                   | push                edx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   03c3                 | add                 eax, ebx
            //   03d3                 | add                 edx, ebx
            //   e8????????           |                     

        $sequence_2 = { 898e5c020000 0fb77c7b10 897df4 8b3cba 897dd4 8b7df4 0fb63c38 }
            // n = 7, score = 300
            //   898e5c020000         | mov                 dword ptr [esi + 0x25c], ecx
            //   0fb77c7b10           | movzx               edi, word ptr [ebx + edi*2 + 0x10]
            //   897df4               | mov                 dword ptr [ebp - 0xc], edi
            //   8b3cba               | mov                 edi, dword ptr [edx + edi*4]
            //   897dd4               | mov                 dword ptr [ebp - 0x2c], edi
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   0fb63c38             | movzx               edi, byte ptr [eax + edi]

        $sequence_3 = { 69c002010000 03c6 c745d800000000 8945e0 8bff 8b45f4 99 }
            // n = 7, score = 300
            //   69c002010000         | imul                eax, eax, 0x102
            //   03c6                 | add                 eax, esi
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8bff                 | mov                 edi, edi
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   99                   | cdq                 

        $sequence_4 = { 4a 8917 8d79ff 893c96 0fb678ff 8b55fc 66c1ea08 }
            // n = 7, score = 300
            //   4a                   | dec                 edx
            //   8917                 | mov                 dword ptr [edi], edx
            //   8d79ff               | lea                 edi, [ecx - 1]
            //   893c96               | mov                 dword ptr [esi + edx*4], edi
            //   0fb678ff             | movzx               edi, byte ptr [eax - 1]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   66c1ea08             | shr                 dx, 8

        $sequence_5 = { 51 89442434 ff15???????? 8b5508 }
            // n = 4, score = 300
            //   51                   | push                ecx
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   ff15????????         |                     
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_6 = { 7c13 53 8bc6 e8???????? 83c404 897e08 e9???????? }
            // n = 7, score = 300
            //   7c13                 | jl                  0x15
            //   53                   | push                ebx
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   897e08               | mov                 dword ptr [esi + 8], edi
            //   e9????????           |                     

        $sequence_7 = { 6a64 8d4598 6a00 50 e8???????? 68c8000000 }
            // n = 6, score = 300
            //   6a64                 | push                0x64
            //   8d4598               | lea                 eax, [ebp - 0x68]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   68c8000000           | push                0xc8

        $sequence_8 = { 8a5c3e03 3ada 75d2 8a543804 8a5c3e04 3ada 75c6 }
            // n = 7, score = 300
            //   8a5c3e03             | mov                 bl, byte ptr [esi + edi + 3]
            //   3ada                 | cmp                 bl, dl
            //   75d2                 | jne                 0xffffffd4
            //   8a543804             | mov                 dl, byte ptr [eax + edi + 4]
            //   8a5c3e04             | mov                 bl, byte ptr [esi + edi + 4]
            //   3ada                 | cmp                 bl, dl
            //   75c6                 | jne                 0xffffffc8

        $sequence_9 = { 8b4510 8d7c50fc 33c0 66894704 8b450c 0fb60410 c1f908 }
            // n = 7, score = 300
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8d7c50fc             | lea                 edi, [eax + edx*2 - 4]
            //   33c0                 | xor                 eax, eax
            //   66894704             | mov                 word ptr [edi + 4], ax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   0fb60410             | movzx               eax, byte ptr [eax + edx]
            //   c1f908               | sar                 ecx, 8

    condition:
        7 of them and filesize < 204800
}