rule win_unidentified_020_cia_vault7_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_020_cia_vault7."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_020_cia_vault7"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b0d???????? 69c960ea0000 51 e8???????? }
            // n = 4, score = 200
            //   8b0d????????         |                     
            //   69c960ea0000         | imul                ecx, ecx, 0xea60
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_1 = { 83c404 c70200000000 56 8b35???????? ffd6 8b45b8 }
            // n = 6, score = 200
            //   83c404               | add                 esp, 4
            //   c70200000000         | mov                 dword ptr [edx], 0
            //   56                   | push                esi
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]

        $sequence_2 = { 7461 6a01 53 e8???????? }
            // n = 4, score = 200
            //   7461                 | je                  0x63
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_3 = { 50 8d8c242c060000 51 68???????? 8d94242c040000 }
            // n = 5, score = 200
            //   50                   | push                eax
            //   8d8c242c060000       | lea                 ecx, [esp + 0x62c]
            //   51                   | push                ecx
            //   68????????           |                     
            //   8d94242c040000       | lea                 edx, [esp + 0x42c]

        $sequence_4 = { c3 53 57 81faffff0000 7657 8b7e20 }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   57                   | push                edi
            //   81faffff0000         | cmp                 edx, 0xffff
            //   7657                 | jbe                 0x59
            //   8b7e20               | mov                 edi, dword ptr [esi + 0x20]

        $sequence_5 = { 6800400000 50 57 ff15???????? eb4f 8d0c4a }
            // n = 6, score = 200
            //   6800400000           | push                0x4000
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff15????????         |                     
            //   eb4f                 | jmp                 0x51
            //   8d0c4a               | lea                 ecx, [edx + ecx*2]

        $sequence_6 = { 5f 8be5 5d c3 8b4dfc 51 ff15???????? }
            // n = 7, score = 200
            //   5f                   | pop                 edi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_7 = { 7506 b805000000 c3 3b8a7c120000 }
            // n = 4, score = 200
            //   7506                 | jne                 8
            //   b805000000           | mov                 eax, 5
            //   c3                   | ret                 
            //   3b8a7c120000         | cmp                 ecx, dword ptr [edx + 0x127c]

        $sequence_8 = { 8bf0 57 56 895dfc e8???????? }
            // n = 5, score = 200
            //   8bf0                 | mov                 esi, eax
            //   57                   | push                edi
            //   56                   | push                esi
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   e8????????           |                     

        $sequence_9 = { 5e 5d c20400 57 be02000000 e8???????? }
            // n = 6, score = 200
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   57                   | push                edi
            //   be02000000           | mov                 esi, 2
            //   e8????????           |                     

    condition:
        7 of them and filesize < 253952
}