rule win_unidentified_042_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_042."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_042"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a20 ba???????? 8bde e8???????? 83c404 85c0 7410 }
            // n = 7, score = 100
            //   6a20                 | push                0x20
            //   ba????????           |                     
            //   8bde                 | mov                 ebx, esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7410                 | je                  0x12

        $sequence_1 = { 52 8b9578ffffff 50 53 8d8d7cffffff e8???????? 83c414 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   8b9578ffffff         | mov                 edx, dword ptr [ebp - 0x88]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   8d8d7cffffff         | lea                 ecx, [ebp - 0x84]
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14

        $sequence_2 = { 33f7 8b7df0 337dec 23f8 337df0 03f7 8bbdd8feffff }
            // n = 7, score = 100
            //   33f7                 | xor                 esi, edi
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]
            //   337dec               | xor                 edi, dword ptr [ebp - 0x14]
            //   23f8                 | and                 edi, eax
            //   337df0               | xor                 edi, dword ptr [ebp - 0x10]
            //   03f7                 | add                 esi, edi
            //   8bbdd8feffff         | mov                 edi, dword ptr [ebp - 0x128]

        $sequence_3 = { e8???????? 83c408 85c0 7809 7e07 03f0 83fe04 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7809                 | js                  0xb
            //   7e07                 | jle                 9
            //   03f0                 | add                 esi, eax
            //   83fe04               | cmp                 esi, 4

        $sequence_4 = { 0bfa 48 75f1 eb03 0fb6f8 }
            // n = 5, score = 100
            //   0bfa                 | or                  edi, edx
            //   48                   | dec                 eax
            //   75f1                 | jne                 0xfffffff3
            //   eb03                 | jmp                 5
            //   0fb6f8               | movzx               edi, al

        $sequence_5 = { 25efff0000 66c1e104 660bc8 66898b50020000 8a4648 2401 0fb6c0 }
            // n = 7, score = 100
            //   25efff0000           | and                 eax, 0xffef
            //   66c1e104             | shl                 cx, 4
            //   660bc8               | or                  cx, ax
            //   66898b50020000       | mov                 word ptr [ebx + 0x250], cx
            //   8a4648               | mov                 al, byte ptr [esi + 0x48]
            //   2401                 | and                 al, 1
            //   0fb6c0               | movzx               eax, al

        $sequence_6 = { c7855cfaffff25da3f2e c78560fafffffafe28be c78564faffffaff05b42 c78568faffff0973699c c7856cfaffffb195ef80 c78570faffffdccc6129 c78574faffff2b44064a }
            // n = 7, score = 100
            //   c7855cfaffff25da3f2e     | mov    dword ptr [ebp - 0x5a4], 0x2e3fda25
            //   c78560fafffffafe28be     | mov    dword ptr [ebp - 0x5a0], 0xbe28fefa
            //   c78564faffffaff05b42     | mov    dword ptr [ebp - 0x59c], 0x425bf0af
            //   c78568faffff0973699c     | mov    dword ptr [ebp - 0x598], 0x9c697309
            //   c7856cfaffffb195ef80     | mov    dword ptr [ebp - 0x594], 0x80ef95b1
            //   c78570faffffdccc6129     | mov    dword ptr [ebp - 0x590], 0x2961ccdc
            //   c78574faffff2b44064a     | mov    dword ptr [ebp - 0x58c], 0x4a06442b

        $sequence_7 = { 1bc0 2556ffffff 33cd 83c011 e8???????? 8be5 }
            // n = 6, score = 100
            //   1bc0                 | sbb                 eax, eax
            //   2556ffffff           | and                 eax, 0xffffff56
            //   33cd                 | xor                 ecx, ebp
            //   83c011               | add                 eax, 0x11
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp

        $sequence_8 = { 8b7df4 8b45e8 83f903 0f8dad000000 85c9 0f88a5000000 8bd1 }
            // n = 7, score = 100
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   83f903               | cmp                 ecx, 3
            //   0f8dad000000         | jge                 0xb3
            //   85c9                 | test                ecx, ecx
            //   0f88a5000000         | js                  0xab
            //   8bd1                 | mov                 edx, ecx

        $sequence_9 = { 6824a4e360 681c781e53 6890000000 6a01 6a02 e8???????? 8b4df8 }
            // n = 7, score = 100
            //   6824a4e360           | push                0x60e3a424
            //   681c781e53           | push                0x531e781c
            //   6890000000           | push                0x90
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   e8????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

    condition:
        7 of them and filesize < 516096
}