rule win_unidentified_080_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_080."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_080"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7859cfdffff34290210 c685a4fdffff0f 89bda8fdffff 89bdacfdffff 89bdb0fdffff 89bdb4fdffff 89bdb8fdffff }
            // n = 7, score = 100
            //   c7859cfdffff34290210     | mov    dword ptr [ebp - 0x264], 0x10022934
            //   c685a4fdffff0f       | mov                 byte ptr [ebp - 0x25c], 0xf
            //   89bda8fdffff         | mov                 dword ptr [ebp - 0x258], edi
            //   89bdacfdffff         | mov                 dword ptr [ebp - 0x254], edi
            //   89bdb0fdffff         | mov                 dword ptr [ebp - 0x250], edi
            //   89bdb4fdffff         | mov                 dword ptr [ebp - 0x24c], edi
            //   89bdb8fdffff         | mov                 dword ptr [ebp - 0x248], edi

        $sequence_1 = { 8b4df8 8b55f0 53 51 52 e8???????? }
            // n = 6, score = 100
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_2 = { 6a04 57 56 c645fc08 ff15???????? 85c0 7504 }
            // n = 7, score = 100
            //   6a04                 | push                4
            //   57                   | push                edi
            //   56                   | push                esi
            //   c645fc08             | mov                 byte ptr [ebp - 4], 8
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6

        $sequence_3 = { 8b742414 83c6f4 81fe???????? 7414 56 ff15???????? }
            // n = 6, score = 100
            //   8b742414             | mov                 esi, dword ptr [esp + 0x14]
            //   83c6f4               | add                 esi, -0xc
            //   81fe????????         |                     
            //   7414                 | je                  0x16
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_4 = { 8b4e14 894f14 8b5618 895718 8b461c 8378f400 8d4f1c }
            // n = 7, score = 100
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]
            //   894f14               | mov                 dword ptr [edi + 0x14], ecx
            //   8b5618               | mov                 edx, dword ptr [esi + 0x18]
            //   895718               | mov                 dword ptr [edi + 0x18], edx
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   8378f400             | cmp                 dword ptr [eax - 0xc], 0
            //   8d4f1c               | lea                 ecx, [edi + 0x1c]

        $sequence_5 = { 8b4604 57 33ff 3bc7 7439 8b4e0c }
            // n = 6, score = 100
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   3bc7                 | cmp                 eax, edi
            //   7439                 | je                  0x3b
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]

        $sequence_6 = { 0f95c1 8d5a01 53 85c9 740b 50 e8???????? }
            // n = 7, score = 100
            //   0f95c1               | setne               cl
            //   8d5a01               | lea                 ebx, [edx + 1]
            //   53                   | push                ebx
            //   85c9                 | test                ecx, ecx
            //   740b                 | je                  0xd
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_7 = { 83ec14 8d45d0 8bf4 8965e4 50 }
            // n = 5, score = 100
            //   83ec14               | sub                 esp, 0x14
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   8bf4                 | mov                 esi, esp
            //   8965e4               | mov                 dword ptr [ebp - 0x1c], esp
            //   50                   | push                eax

        $sequence_8 = { 6804900000 c707???????? e8???????? 6804500000 894704 e8???????? 894708 }
            // n = 7, score = 100
            //   6804900000           | push                0x9004
            //   c707????????         |                     
            //   e8????????           |                     
            //   6804500000           | push                0x5004
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   e8????????           |                     
            //   894708               | mov                 dword ptr [edi + 8], eax

        $sequence_9 = { 85c0 7456 8dbda4fdffff e8???????? 8bc7 50 b8???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7456                 | je                  0x58
            //   8dbda4fdffff         | lea                 edi, [ebp - 0x25c]
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   50                   | push                eax
            //   b8????????           |                     

    condition:
        7 of them and filesize < 392192
}